/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.enumeration.EnumItem;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EnumMeta<T extends EnumItem> {
    private final Class enumClazz;
    private final List<T> items = new ArrayList<T>();
    private T enumDefault = null;

    public EnumMeta(Class enumClazz) {
        this.enumClazz = enumClazz;
    }

    protected void addItem(T item) {
        this.items.add(item);
        if (this.items.size() == 1) {
            ((EnumItem)item).setDefault();
        }
    }

    public T getDefault() {
        return this.enumDefault;
    }

    public Class getEnumClazz() {
        return this.enumClazz;
    }

    public T getItem(String id) {
        if (id == null) {
            return null;
        }
        for (EnumItem element : this.items) {
            if (!element.getId().equals(id)) continue;
            return (T)element;
        }
        return null;
    }

    public T getItemOrDefault(String id) {
        T item = this.getItem(id);
        if (item == null) {
            item = this.getDefault();
        }
        return item;
    }

    public T[] getItems() {
        return this.items.toArray((EnumItem[])Array.newInstance(this.enumClazz, this.items.size()));
    }

    public T getMax() {
        EnumItem max = null;
        for (EnumItem element : this.items) {
            if (max != null && element.getWeight() <= max.getWeight()) continue;
            max = element;
        }
        return (T)max;
    }

    public T getMin() {
        EnumItem min = null;
        for (EnumItem element : this.items) {
            if (min != null && element.getWeight() >= min.getWeight()) continue;
            min = element;
        }
        return (T)min;
    }

    protected void setDefault(T item) {
        this.enumDefault = item;
    }

    public void sort() {
        this.sort(new Comparator<EnumItem>(){

            @Override
            public int compare(EnumItem o1, EnumItem o2) {
                return o1.getLabel().compareToIgnoreCase(o2.getLabel());
            }
        });
    }

    public void sort(Comparator<EnumItem> c) {
        Collections.sort(this.items, c);
    }
}

