/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.event;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventDispatcher
implements INotificationSupport,
INotificationListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object owner;
    private final List<Subscription> subscriptions = new CopyOnWriteArrayList<Subscription>();

    public EventDispatcher(Object pOwner) {
        this.owner = pOwner;
    }

    @Override
    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener may not be null");
        }
        this.subscriptions.add(new Subscription(type, listener));
    }

    public void attach(INotificationSupport support) {
        for (Subscription subscription : this.subscriptions) {
            support.addNotificationListener(subscription.type, subscription.listener);
        }
    }

    public void clear() {
        this.subscriptions.clear();
    }

    public void detach(INotificationSupport support) {
        for (Subscription subscription : this.subscriptions) {
            support.removeNotificationListener(subscription.type, subscription.listener);
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    @Override
    public void handleEvent(Event event) {
        for (Subscription subscription : this.subscriptions) {
            EventType type = event.getEventType();
            if (subscription.type != type && subscription.type != EventType.ALWAYS) continue;
            subscription.listener.handleEvent(event);
        }
    }

    public boolean hasListener() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.subscriptions.isEmpty();
    }

    @Override
    public void removeNotificationListener(EventType type, INotificationListener listener) {
        for (Subscription subscription : this.subscriptions) {
            if (subscription.type != type || subscription.listener != listener) continue;
            this.subscriptions.remove(subscription);
        }
    }

    public void triggerChanged(String attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent e = new AttributeChangedEvent(this.getOwner(), attribute, oldValue, newValue);
        this.triggerEvent(e);
    }

    public void triggerEvent(Event event) {
        this.handleEvent(event);
    }

    static class Subscription
    implements Serializable {
        public EventType type;
        public INotificationListener listener;

        public Subscription(EventType type, INotificationListener listener) {
            this.type = type;
            this.listener = listener;
        }
    }
}

