/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.event;

import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.event.ActivatedEvent;
import de.intarsys.tools.event.CreatedEvent;
import de.intarsys.tools.event.DeactivatedEvent;
import de.intarsys.tools.event.DestroyedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.event.StartedEvent;
import de.intarsys.tools.event.StopRequestedEvent;
import de.intarsys.tools.event.StoppedEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class LifecycleWatchdog
implements IStartStop {
    private final INotificationSupport object;
    private final List armedObjects = new ArrayList();
    private boolean started = false;
    private String label;
    protected final INotificationListener listenObjectLifecycle = new INotificationListener(){

        @Override
        public void handleEvent(Event event) {
            LifecycleWatchdog.this.onObjectLifecycleEvent(event);
        }

        public String toString() {
            return LifecycleWatchdog.this.toString();
        }
    };
    protected final INotificationListener listenFactoryLifecycle = new INotificationListener(){

        @Override
        public void handleEvent(Event event) {
            LifecycleWatchdog.this.onFactoryLifecycleEvent(event);
        }

        public String toString() {
            return LifecycleWatchdog.this.toString();
        }
    };

    public LifecycleWatchdog(INotificationSupport factory) {
        if (factory == null) {
            throw new NullPointerException("watchdog must have a factory");
        }
        this.object = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void arm(INotificationSupport object) {
        List list = this.armedObjects;
        synchronized (list) {
            this.armedObjects.add(object);
        }
        object.addNotificationListener(StartedEvent.ID, this.listenObjectLifecycle);
        object.addNotificationListener(ActivatedEvent.ID, this.listenObjectLifecycle);
        object.addNotificationListener(DeactivatedEvent.ID, this.listenObjectLifecycle);
        object.addNotificationListener(StopRequestedEvent.ID, this.listenObjectLifecycle);
        object.addNotificationListener(StoppedEvent.ID, this.listenObjectLifecycle);
        object.addNotificationListener(DestroyedEvent.ID, this.listenObjectLifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disarm(INotificationSupport object) {
        List list = this.armedObjects;
        synchronized (list) {
            this.armedObjects.remove(object);
        }
        object.removeNotificationListener(StartedEvent.ID, this.listenObjectLifecycle);
        object.removeNotificationListener(ActivatedEvent.ID, this.listenObjectLifecycle);
        object.removeNotificationListener(DeactivatedEvent.ID, this.listenObjectLifecycle);
        object.removeNotificationListener(StopRequestedEvent.ID, this.listenObjectLifecycle);
        object.removeNotificationListener(StoppedEvent.ID, this.listenObjectLifecycle);
        object.removeNotificationListener(DestroyedEvent.ID, this.listenObjectLifecycle);
    }

    public String getLabel() {
        return this.label;
    }

    public INotificationSupport getObject() {
        return this.object;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    protected final void myFactoryStarted(Event event) {
        this.start();
    }

    protected final void myFactoryStopped(Event event) {
        this.stop();
    }

    protected final void myObjectActivated(Object object) {
        this.objectActivated(object);
    }

    protected final void myObjectCreated(Object object) {
        if (!this.supports(object)) {
            return;
        }
        this.arm((INotificationSupport)object);
        this.objectCreated(object);
    }

    protected final void myObjectDeactivated(Object object) {
        this.objectDeactivated(object);
    }

    protected final void myObjectDestroyed(Object object) {
        this.disarm((INotificationSupport)object);
        this.objectDestroyed(object);
    }

    protected final void myObjectStarted(Object object) {
        this.objectStarted(object);
    }

    protected final void myObjectStopped(Object object) {
        this.disarm((INotificationSupport)object);
        this.objectStopped(object);
    }

    protected final boolean myObjectStopRequested(Object object) {
        return this.objectStopRequested(object);
    }

    protected void objectActivated(Object object) {
    }

    protected void objectCreated(Object object) {
    }

    protected void objectDeactivated(Object object) {
    }

    protected void objectDestroyed(Object object) {
    }

    protected void objectStarted(Object object) {
    }

    protected void objectStopped(Object object) {
    }

    protected boolean objectStopRequested(Object object) {
        return true;
    }

    protected void onFactoryLifecycleEvent(Event event) {
        if (event instanceof StartedEvent) {
            this.myFactoryStarted(event);
        } else if (event instanceof StoppedEvent) {
            this.myFactoryStopped(event);
        }
    }

    protected void onObjectLifecycleEvent(Event event) {
        if (event instanceof CreatedEvent) {
            CreatedEvent cpe = (CreatedEvent)event;
            this.myObjectCreated(cpe.getInstance());
        } else if (event instanceof DestroyedEvent) {
            this.myObjectDestroyed(event.getSource());
        } else if (event instanceof StartedEvent) {
            this.myObjectStarted(event.getSource());
        } else if (event instanceof ActivatedEvent) {
            this.myObjectActivated(event.getSource());
        } else if (event instanceof DeactivatedEvent) {
            this.myObjectDeactivated(event.getSource());
        } else if (event instanceof StopRequestedEvent) {
            event.setRc(this.myObjectStopRequested(event.getSource()));
        } else if (event instanceof StoppedEvent) {
            this.myObjectStopped(event.getSource());
        }
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void start() {
        this.object.addNotificationListener(CreatedEvent.ID, this.listenObjectLifecycle);
        this.started = true;
    }

    public void startAuto() {
        this.object.addNotificationListener(StartedEvent.ID, this.listenFactoryLifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ArrayList toBeDisarmed;
        this.object.removeNotificationListener(CreatedEvent.ID, this.listenObjectLifecycle);
        List list = this.armedObjects;
        synchronized (list) {
            toBeDisarmed = new ArrayList(this.armedObjects);
        }
        for (INotificationSupport object : toBeDisarmed) {
            this.disarm(object);
        }
    }

    @Override
    public boolean stopRequested(Set visited) {
        return true;
    }

    protected boolean supports(Object object) {
        return true;
    }

    public String toString() {
        return this.getLabel();
    }
}

