/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.eventbus;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.eventbus.EventBus;
import de.intarsys.tools.eventbus.EventSourceAll;
import de.intarsys.tools.eventbus.EventSourceClass;
import de.intarsys.tools.eventbus.EventSourcePredicate;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import javax.annotation.PostConstruct;

public class FunctorSubscription
implements IElementConfigurable {
    private final INotificationListener listener = new INotificationListener(){

        @Override
        public void handleEvent(Event event) {
            FunctorSubscription.this.onNotification(event);
        }
    };
    private EventType type;
    private EventSourcePredicate predicate;
    private IFunctor functor;

    @Override
    public void configure(IElement element) throws ConfigurationException {
        try {
            Class<Event> eventClazz = ElementTools.createClass(element, "event", Event.class, null);
            this.type = eventClazz == null ? EventType.ALWAYS : EventType.lookupEventType(eventClazz.getName());
            Class<Object> sourceClazz = ElementTools.createClass(element, "source", Object.class, null);
            this.predicate = sourceClazz == null ? new EventSourceAll() : new EventSourceClass(sourceClazz);
            this.functor = ElementTools.createFunctor(this, element, "functor", null);
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected void onNotification(Event event) {
        try {
            Args args = Args.create();
            FunctorCall call = new FunctorCall(this, args);
            this.functor.perform(call);
        }
        catch (FunctorInvocationException e) {
            e.printStackTrace();
        }
    }

    @PostConstruct
    public void postConstruct() {
        EventBus.get().subscribe(this.predicate, this.type, this.listener);
    }
}

