/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.exception;

import de.intarsys.tools.exception.KnownReason;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;

public class ExceptionTools {
    @Deprecated
    public static IOException createIOException(String message, Throwable cause) {
        IOException ioe = new IOException(message);
        ioe.initCause(cause);
        return ioe;
    }

    public static void fail() {
        throw new RuntimeException("failed");
    }

    public static <T> T futureSimpleGet(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof Error) {
                throw (Error)ex.getCause();
            }
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new InternalError("Program execution should not reach this point.");
        }
    }

    public static <T extends Number> T futureSimpleGetNumber(Future<T> future) {
        Number result = (Number)ExceptionTools.futureSimpleGet(future);
        if (result == null) {
            result = new Integer(-1);
        }
        return (T)result;
    }

    public static <T extends Throwable> T getInChain(Throwable t, Class<T> clazz) {
        if (clazz.isInstance(t)) {
            return (T)t;
        }
        if (t.getCause() != null) {
            return ExceptionTools.getInChain(t.getCause(), clazz);
        }
        return null;
    }

    public static Throwable getRoot(Throwable t) {
        Throwable root = t;
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    public static String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static boolean isInChain(Throwable t, Class<?> clazz) {
        if (clazz.isInstance(t)) {
            return true;
        }
        if (t.getCause() != null) {
            return ExceptionTools.isInChain(t.getCause(), clazz);
        }
        return false;
    }

    public static boolean isKnownReason(Throwable t) {
        if (t instanceof KnownReason) {
            return true;
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            return ExceptionTools.isKnownReason(cause);
        }
        return false;
    }

    public static boolean isTimeout(Throwable t) {
        if (t instanceof TimeoutException) {
            return true;
        }
        Throwable cause = t.getCause();
        if (cause != null) {
            return ExceptionTools.isTimeout(cause);
        }
        return false;
    }

    public static <T extends Throwable> T createWithCause(Class<T> clazz, Throwable t) {
        Throwable cause;
        Throwable throwable = cause = t.getCause() == null ? t : t.getCause();
        if (clazz.isInstance(cause)) {
            return (T)cause;
        }
        try {
            Constructor<T> c = clazz.getConstructor(Throwable.class);
            Throwable newThrowable = (Throwable)c.newInstance(clazz);
            return (T)newThrowable;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed creating exception type " + clazz.getName(), t);
        }
    }
}

