/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.component.ActivityLocal;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.functor.IArgs;

public class ActivityContextAwareResolver
implements IStringEvaluator {
    private static ActivityLocal<ScopedResolver> resolver = new ActivityLocal();

    public static synchronized void add(IStringEvaluator pResolver) {
        ScopedResolver tempResolver = resolver.get();
        if (tempResolver == null) {
            tempResolver = new ScopedResolver();
            resolver.set(tempResolver);
        }
        tempResolver.addResolver(pResolver);
    }

    public static synchronized IStringEvaluator add(String key, IStringEvaluator pResolver) {
        ScopedResolver tempResolver = resolver.get();
        if (tempResolver == null) {
            tempResolver = new ScopedResolver();
            resolver.set(tempResolver);
        }
        MapResolver newResolver = MapResolver.create(key, pResolver);
        tempResolver.addResolver(newResolver);
        return newResolver;
    }

    public static synchronized void remove(IStringEvaluator pResolver) {
        ScopedResolver tempResolver = resolver.get();
        if (resolver == null) {
            return;
        }
        tempResolver.removeResolver(pResolver);
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        ScopedResolver tempResolver = resolver.get();
        if (tempResolver == null) {
            throw new EvaluationException("can't evaluate '" + expression + "'");
        }
        return tempResolver.evaluate(expression, args);
    }
}

