/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.adapter.AdapterOutlet;
import de.intarsys.tools.expression.ArrayResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorSupport;
import de.intarsys.tools.expression.ListResolver;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.expression.StaticArgsResolver;
import de.intarsys.tools.expression.VariableNamespaceResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.variable.IVariableNamespace;
import java.util.List;
import java.util.Map;

public abstract class ContainerResolver
implements IStringEvaluator {
    private IStringEvaluator exceptionResolver;
    private final char separator;

    public ContainerResolver() {
        this('.');
    }

    public ContainerResolver(char separator) {
        this.separator = separator;
    }

    protected abstract Object basicEvaluate(String var1, IArgs var2) throws EvaluationException;

    protected IStringEvaluator createStringEvaluator(Object object) {
        if (object instanceof IStringEvaluator) {
            return (IStringEvaluator)object;
        }
        if (object instanceof IStringEvaluatorSupport) {
            return ((IStringEvaluatorSupport)object).getStringEvaluator();
        }
        if (object instanceof Map) {
            return new MapResolver((Map)object, false);
        }
        if (object instanceof List) {
            return new ListResolver((List)object);
        }
        if (object instanceof IArgs) {
            return new StaticArgsResolver((IArgs)object);
        }
        if (object instanceof IVariableNamespace) {
            return new VariableNamespaceResolver((IVariableNamespace)object);
        }
        if (object instanceof Object[]) {
            return new ArrayResolver((Object[])object);
        }
        if (object == null) {
            return null;
        }
        IStringEvaluator evaluator = AdapterOutlet.get().getAdapter(object, IStringEvaluator.class);
        if (evaluator == null) {
            return new ReflectiveResolver(object);
        }
        return evaluator;
    }

    @Override
    public final Object evaluate(String expression, IArgs args) throws EvaluationException {
        String tempExpr = expression;
        int pos = tempExpr.indexOf(this.getSeparator());
        if (pos == -1) {
            return this.evaluatePrefix(tempExpr, args);
        }
        String name = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        Object result = this.evaluatePrefix(name, args);
        IStringEvaluator subResolver = this.createStringEvaluator(result);
        if (subResolver != null) {
            return subResolver.evaluate(pathTrail, args);
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    protected Object evaluatePrefix(String prefix, IArgs args) throws EvaluationException {
        Object result;
        try {
            result = this.basicEvaluate(prefix, args);
        }
        catch (EvaluationException e) {
            if (this.exceptionResolver != null) {
                result = this.exceptionResolver.evaluate(prefix, args);
            }
            throw e;
        }
        if (result instanceof IValueHolder) {
            result = ((IValueHolder)result).get();
        }
        return result;
    }

    public IStringEvaluator getExceptionResolver() {
        return this.exceptionResolver;
    }

    public final char getSeparator() {
        return this.separator;
    }

    public void setExceptionResolver(IStringEvaluator exceptionResolver) {
        this.exceptionResolver = exceptionResolver;
    }
}

