/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.util.HashMap;
import java.util.Map;

public class EntityResolver
extends ContainerResolver {
    private static Map<String, String> entities = new HashMap<String, String>();

    static {
        entities.put("amp", "&");
        entities.put("gt", ">");
        entities.put("lt", "<");
        entities.put("copy", "\u00a9");
        entities.put("trade", "\u2122");
        entities.put("cr", "\r");
        entities.put("lf", "\n");
        entities.put("quot", "\"");
        entities.put("squot", "'");
        entities.put("slash", "/");
        entities.put("backslash", "\\");
        entities.put("nl", StringTools.LS);
    }

    @Override
    protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
        try {
            if (expression.startsWith("x")) {
                String code = expression.substring(1);
                int index = Integer.parseInt(code, 16);
                return new String(Character.toChars(index));
            }
            if (expression.startsWith("o")) {
                String code = expression.substring(1);
                int index = Integer.parseInt(code, 8);
                return new String(Character.toChars(index));
            }
            int index = Integer.parseInt(expression);
            return new String(Character.toChars(index));
        }
        catch (Exception e) {
            return entities.get(expression);
        }
    }
}

