/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;

public class EnvironmentResolver
implements IStringEvaluator {
    private IFileEnvironment environment;

    public EnvironmentResolver() {
        this(FileEnvironment.get());
    }

    public EnvironmentResolver(IFileEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if ("basedir".equals(expression)) {
            return this.environment.getBaseDir().getAbsolutePath();
        }
        if ("profiledir".equals(expression)) {
            return this.environment.getProfileDir().getAbsolutePath();
        }
        if ("workingdir".equals(expression)) {
            return this.environment.getWorkingDir().getAbsolutePath();
        }
        if ("tempdir".equals(expression)) {
            return this.environment.getTempDir().getAbsolutePath();
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }
}

