/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;

public class MapResolver
extends ContainerResolver {
    private final Map variables;
    private boolean strict;

    public static MapResolver create() {
        return new MapResolver();
    }

    public static MapResolver create(String key, IStringEvaluator resolver) {
        return new MapResolver().put(key, resolver);
    }

    public MapResolver() {
        this(new HashMap(), false);
    }

    public MapResolver(boolean strict) {
        this(new HashMap(), strict);
    }

    public MapResolver(Map variables) {
        this(variables, false);
    }

    public MapResolver(Map variables, boolean strict) {
        this.variables = variables;
        this.strict = strict;
    }

    @Override
    protected Object basicEvaluate(String expression, IArgs args) throws EvaluationException {
        if (this.variables.containsKey(expression)) {
            return this.variables.get(expression);
        }
        if (this.strict) {
            throw new EvaluationException("can't evaluate '" + expression + "'");
        }
        return null;
    }

    public MapResolver define(String key, Object value) {
        this.variables.put(key, value);
        return this;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public MapResolver put(String key, Object value) {
        this.variables.put(key, value);
        return this;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public static class AddEntry {
        private MapResolver target;
        private IStringEvaluator evaluator;
        private String name;

        public IStringEvaluator getEvaluator() {
            return this.evaluator;
        }

        public String getName() {
            return this.name;
        }

        public MapResolver getTarget() {
            return this.target;
        }

        @PostConstruct
        public void install() {
            this.getTarget().put(this.getName(), this.getEvaluator());
        }

        public void setEvaluator(IStringEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTarget(MapResolver target) {
            this.target = target;
        }
    }
}

