/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.ReflectiveResolver;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorRegistry;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;

public class ProcessingDecorator
implements IStringEvaluator {
    public static final char PROCESSING_SEPARATOR = ':';
    public static final String ARG_SEPARATOR = ",";
    public static final char CLOSE_BRACE = ')';
    public static final char OPEN_BRACE = '(';
    public static final char CODE_REFLECTION = '.';
    public static final char CODE_FUNCTOR = '#';
    public static final char CODE_DEEPRECURSION = '*';
    public static final char CODE_SHALLOWRECURSION = '+';
    public static final char CODE_CONDITIONAL = '?';
    private static IFunctorRegistry formattingFunctors;
    private IStringEvaluator evaluator;
    private char separator = (char)58;
    private String separatorString = "" + this.separator;
    private IStringEvaluator recursionEvaluator;
    private static final String ARG_RECURSION = "de.intarsys.tools.expression.ProcessingDecorator.recursion";

    protected static Object formatFunctor(Object value, String format) throws FunctorInvocationException {
        IFunctorRegistry registry = ProcessingDecorator.getFormattingFunctors();
        if (registry == null) {
            return value;
        }
        int openBrace = format.indexOf(40);
        if (openBrace == -1) {
            openBrace = format.length();
        }
        int closeBrace = format.indexOf(41);
        String formatterId = format.substring(0, openBrace);
        String[] argStrings = openBrace < closeBrace ? format.substring(openBrace + 1, closeBrace).split(ARG_SEPARATOR) : new String[]{};
        IFunctor formatter = registry.lookupFunctor(formatterId);
        if (formatter == null) {
            throw new FunctorInvocationException("formatter '" + formatterId + "' not found");
        }
        Args args = Args.createIndexed(value, argStrings);
        FunctorCall call = new FunctorCall(value, args);
        return formatter.perform(call);
    }

    public static IFunctorRegistry getFormattingFunctors() {
        return formattingFunctors;
    }

    public static void setFormattingFunctors(IFunctorRegistry formattingFunctors) {
        ProcessingDecorator.formattingFunctors = formattingFunctors;
    }

    public ProcessingDecorator(IStringEvaluator evaluator) {
        this.evaluator = evaluator;
        this.recursionEvaluator = evaluator;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        Object value;
        String[] instructions = expression.split(this.getSeparatorString(), -1);
        String valueExpression = instructions[0].trim();
        if (valueExpression.startsWith("\"")) {
            try {
                value = StringTools.unquote(valueExpression);
            }
            catch (IOException e) {
                throw new EvaluationException(e);
            }
        } else {
            value = this.evaluator.evaluate(valueExpression, args);
        }
        int i = 1;
        while (i < instructions.length) {
            value = this.evaluateInstruction(value, args, instructions[i]);
            ++i;
        }
        return value;
    }

    protected Object evaluateConditional(Object value, IArgs args, String instruction) throws EvaluationException {
        String expression = instruction.trim().substring(1);
        boolean ok = ArgTools.getBool(args, expression, false);
        return ok ? value : null;
    }

    protected Object evaluateDeepRecursion(Object value, IArgs args, String instruction) throws EvaluationException {
        int depth = (Integer)args.get(ARG_RECURSION, (Object)10);
        if (depth == -1) {
            return value;
        }
        if (value instanceof String) {
            args.put(ARG_RECURSION, (Object)(--depth));
            try {
                Object result = this.recursionEvaluator.evaluate((String)value, args);
                if (value.equals(result)) {
                    return value;
                }
                return this.evaluateDeepRecursion(result, args, instruction);
            }
            catch (Exception e) {
                return value;
            }
        }
        return value;
    }

    protected Object evaluateFunctor(Object value, IArgs args, String instruction) throws EvaluationException {
        try {
            return ProcessingDecorator.formatFunctor(value, instruction.substring(1));
        }
        catch (FunctorInvocationException e) {
            throw new EvaluationException(e.getCause() == null ? e : e.getCause());
        }
    }

    protected Object evaluateInstruction(Object value, IArgs args, String instruction) throws EvaluationException {
        if (instruction.length() == 0) {
            return StringTools.format(value, instruction);
        }
        char c = instruction.charAt(0);
        if (c == '+') {
            return this.evaluateDeepRecursion(value, args, instruction);
        }
        if (c == '*') {
            return this.evaluateDeepRecursion(value, args, instruction);
        }
        if (c == '#') {
            return this.evaluateFunctor(value, args, instruction);
        }
        if (c == '?') {
            return this.evaluateConditional(value, args, instruction);
        }
        if (c == '.') {
            return this.evaluateReflection(value, args, instruction);
        }
        return StringTools.format(value, instruction);
    }

    protected Object evaluateReflection(Object value, IArgs args, String instruction) throws EvaluationException {
        ReflectiveResolver reflector = new ReflectiveResolver(value);
        return reflector.evaluate(instruction, args);
    }

    protected Object evaluateShallowRecursion(Object value, IArgs args, String instruction) throws EvaluationException {
        int depth = (Integer)args.get(ARG_RECURSION, (Object)1);
        if (depth == -1) {
            throw new EvaluationException("expression nested to deeply");
        }
        args.put(ARG_RECURSION, (Object)depth--);
        return this.recursionEvaluator.evaluate(String.valueOf(value), args);
    }

    public IStringEvaluator getEvaluator() {
        return this.evaluator;
    }

    public IStringEvaluator getRecursionEvaluator() {
        return this.recursionEvaluator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public String getSeparatorString() {
        return this.separatorString;
    }

    public void setRecursionEvaluator(IStringEvaluator recursionEvaluator) {
        this.recursionEvaluator = recursionEvaluator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }
}

