/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.List;

public class ScopedResolver
implements IStringEvaluator {
    private List<IStringEvaluator> resolvers = new ArrayList<IStringEvaluator>();

    public static ScopedResolver create(IStringEvaluator ... evaluator) {
        ScopedResolver resolver = new ScopedResolver();
        int i = 0;
        while (i < evaluator.length) {
            resolver.addResolver(evaluator[i]);
            ++i;
        }
        return resolver;
    }

    public void addResolver(IStringEvaluator resolver) {
        this.resolvers.add(resolver);
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        for (IStringEvaluator resolver : this.resolvers) {
            try {
                return resolver.evaluate(expression, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    public IStringEvaluator popResolver() {
        if (this.resolvers.size() == 0) {
            return null;
        }
        return this.resolvers.remove(0);
    }

    public void pushResolver(IStringEvaluator resolver) {
        this.resolvers.add(0, resolver);
    }

    public void removeResolver(IStringEvaluator resolver) {
        this.resolvers.remove(resolver);
    }
}

