/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.PropertiesResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.system.SystemTools;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SystemResolver
implements IStringEvaluator {
    private static int COUNTER = 0;
    private static long UNIQUETIME = 0L;
    private static final Map<String, Integer> counters = new HashMap<String, Integer>();
    private static final PropertiesResolver PropertiesResolver = new PropertiesResolver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if (expression != null) {
            String[] tempStrings;
            if ("millis".equals(expression) || "time".equals(expression)) {
                return System.currentTimeMillis();
            }
            if ("uniquemillis".equals(expression) || "uniquetime".equals(expression)) {
                Class<SystemResolver> clazz = SystemResolver.class;
                synchronized (SystemResolver.class) {
                    long temp = System.currentTimeMillis();
                    if (temp <= UNIQUETIME) {
                        temp = UNIQUETIME + 1L;
                    }
                    UNIQUETIME = temp;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return temp;
                }
            }
            if ("uuid".equals(expression)) {
                return UUID.randomUUID().toString();
            }
            if ("counter".equals(expression)) {
                Class<SystemResolver> clazz = SystemResolver.class;
                synchronized (SystemResolver.class) {
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return COUNTER++;
                }
            }
            if (expression.startsWith("counters.") && (tempStrings = expression.split("\\.", 2)).length == 2) {
                Class<SystemResolver> clazz = SystemResolver.class;
                synchronized (SystemResolver.class) {
                    Integer count = counters.get(tempStrings[1]);
                    if (count == null) {
                        count = 0;
                    }
                    counters.put(tempStrings[1], count + 1);
                    // ** MonitorExit[var4_7] (shouldn't be in output)
                    return count;
                }
            }
            if (expression.startsWith("getenv.") && (tempStrings = expression.split("\\.", 2)).length == 2) {
                return System.getenv(tempStrings[1]);
            }
            if (expression.startsWith("properties.")) {
                tempStrings = expression.split("\\.", 2);
                if (tempStrings.length == 2) {
                    return PropertiesResolver.evaluate(tempStrings[1], args);
                }
                return null;
            }
            if ("architecture".equals(expression)) {
                return this.getArchitecture();
            }
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }

    protected String getArchitecture() {
        String arch = SystemTools.getOSArch();
        if (arch != null && arch.indexOf("64") > -1) {
            return "64-bit";
        }
        return "32-bit";
    }
}

