/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.ProcessingDecorator;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reader.DirectTagReader;
import de.intarsys.tools.reader.IDirectTagHandler;
import de.intarsys.tools.reader.ILocationProvider;
import java.io.IOException;
import java.io.StringReader;

public class TaggedStringEvaluator
implements IStringEvaluator {
    private boolean escape;
    private final IStringEvaluator evaluator;
    private final IDirectTagHandler handler = new IDirectTagHandler(){

        @Override
        public Object endTag(String tagContent, Object context) throws IOException {
            return TaggedStringEvaluator.this.evaluateExpression(tagContent, (IArgs)context);
        }

        @Override
        public void setLocationProvider(ILocationProvider location) {
        }

        @Override
        public void startTag() {
        }
    };
    private boolean swallowExceptions = true;

    public static TaggedStringEvaluator decorate(IStringEvaluator ... resolver) {
        IStringEvaluator temp = resolver.length > 1 ? ScopedResolver.create(resolver) : resolver[0];
        ProcessingDecorator decorator = new ProcessingDecorator(temp);
        TaggedStringEvaluator result = new TaggedStringEvaluator(decorator, false);
        decorator.setRecursionEvaluator(result);
        return result;
    }

    protected TaggedStringEvaluator(IStringEvaluator resolver) {
        this(resolver, false);
    }

    public TaggedStringEvaluator(IStringEvaluator resolver, boolean escape) {
        this.evaluator = resolver;
        this.escape = escape;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if (expression.indexOf(36) < 0) {
            return expression;
        }
        try {
            StringReader base = new StringReader(expression);
            DirectTagReader reader = new DirectTagReader(base, this.handler, args, this.isEscape());
            reader.setForceToString(false);
            int length = expression.length() * 2;
            StringBuilder sb = new StringBuilder(length);
            char[] c = new char[length];
            int i = reader.read(c);
            while (i != -1) {
                sb.append(c, 0, i);
                i = reader.read(c);
            }
            if (sb.length() == 0 && reader.hasResolvedObject()) {
                return reader.getResolvedObject();
            }
            return sb.toString();
        }
        catch (IOException e) {
            if (this.isSwallowExceptions()) {
                return "<error>";
            }
            throw new EvaluationException(e);
        }
    }

    protected Object evaluateExpression(String expression, IArgs args) throws IOException {
        try {
            return this.evaluator.evaluate(expression, args);
        }
        catch (EvaluationException e) {
            if (this.isSwallowExceptions()) {
                return "<error evaluating '" + expression + "' (" + e.getMessage() + ")>";
            }
            throw ExceptionTools.createIOException("<error evaluating '" + expression + "' (" + e.getMessage() + ")>", e);
        }
    }

    public IStringEvaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public boolean isSwallowExceptions() {
        return this.swallowExceptions;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setSwallowExceptions(boolean swallowExceptions) {
        this.swallowExceptions = swallowExceptions;
    }
}

