/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.LazyTemplateEvaluator;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.util.Map;
import javax.annotation.PostConstruct;

public final class TemplateEvaluator {
    private static IStringEvaluator ACTIVE = new LazyTemplateEvaluator();

    public static IStringEvaluator get() {
        return ACTIVE;
    }

    public static void set(IStringEvaluator active) {
        ACTIVE = active;
    }

    public static String translate(String template, final Map<String, String> expressionMap) {
        IStringEvaluator resolver = new IStringEvaluator(){

            @Override
            public Object evaluate(String expression, IArgs args) throws EvaluationException {
                String[] instructions = expression.split(":", 2);
                String valueExpression = instructions[0].trim();
                String replacement = (String)expressionMap.get(valueExpression);
                if (replacement == null) {
                    replacement = expression;
                } else if (instructions.length > 1) {
                    replacement = String.valueOf(replacement) + ":" + instructions[1];
                }
                return "${" + replacement + "}";
            }
        };
        TaggedStringEvaluator evaluator = new TaggedStringEvaluator(resolver);
        try {
            return (String)evaluator.evaluate(template, Args.create());
        }
        catch (EvaluationException e) {
            return template;
        }
    }

    private TemplateEvaluator() {
    }

    public static class Installer {
        private IStringEvaluator resolver;

        public IStringEvaluator getResolver() {
            return this.resolver;
        }

        @PostConstruct
        public void install() {
            TemplateEvaluator.set(TaggedStringEvaluator.decorate(this.getResolver()));
        }

        public void setResolver(IStringEvaluator evaluator) {
            this.resolver = evaluator;
        }
    }
}

