/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.facade;

import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.facade.FacadeFactory;
import de.intarsys.tools.facade.IFacade;
import de.intarsys.tools.facade.IFacadeFactory;

public class DelegatingFacadeFactory
extends FacadeFactory {
    private IFacadeFactory[] factories = new IFacadeFactory[10];
    private int count = 0;
    private static final Object ATTR_FACADE = new Object();

    protected IFacade basicCreate(Object nativeObject) {
        int i = 0;
        while (i < this.count) {
            IFacade result = this.factories[i].createFacade(nativeObject);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public void addFactory(IFacadeFactory factory) {
        if (this.count >= this.factories.length) {
            IFacadeFactory[] tempFactories = new IFacadeFactory[this.count + 2];
            System.arraycopy(this.factories, 0, tempFactories, 0, this.count);
            this.factories = tempFactories;
        }
        this.factories[this.count++] = factory;
    }

    public void removeFactory(IFacadeFactory factory) {
        int i = 0;
        while (i < this.count) {
            IFacadeFactory oldFactory = this.factories[i];
            if (oldFactory == factory) {
                if (i + 1 < this.count) {
                    System.arraycopy(this.factories, i + 1, this.factories, i, this.count - i - 1);
                }
                this.factories[this.count--] = null;
            }
            ++i;
        }
    }

    @Override
    public final IFacade createFacade(Object nativeObject) {
        if (nativeObject instanceof IAttributeSupport) {
            IAttributeSupport as = (IAttributeSupport)nativeObject;
            IFacade result = (IFacade)as.getAttribute(ATTR_FACADE);
            if (result == null && (result = this.basicCreate(nativeObject)) != null) {
                as.setAttribute(ATTR_FACADE, result);
            }
            return result;
        }
        if (nativeObject != null) {
            return this.basicCreate(nativeObject);
        }
        return null;
    }
}

