/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.category.CategoryRegistry;
import de.intarsys.tools.category.ICategory;
import de.intarsys.tools.category.ICategorySupport;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.component.IInitializeable;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.factory.CanonicalFromFactoryConverter;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.ILocatorFactorySupport;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.message.Message;
import de.intarsys.tools.message.MessageBundle;
import de.intarsys.tools.message.MessageBundleTools;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.IClassLoaderAccess;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.tag.TagTools;
import java.io.File;

public abstract class CommonFactory<T>
implements IFactory<T>,
IPresentationSupport,
IElementConfigurable,
IContextSupport,
IClassLoaderSupport,
ILocatorFactorySupport,
IFileEnvironment,
ICategorySupport,
IAttributeSupport {
    private ICategory category;
    private ClassLoader classLoader;
    private Object description;
    private IElement configuration;
    private IElement instanceConfiguration;
    private final ILocatorFactory locatorFactory;
    private String iconName;
    private String id;
    private Object label;
    private Object tip;
    private Object context;
    private final AttributeMap attributes = new AttributeMap();
    public static final String ARG_CONFIGURATION = "configuration";
    public static final String ARG_CONTEXT = "context";
    public static final String ARG_CLASSLOADER = "classLoader";

    static {
        new CanonicalFromFactoryConverter();
    }

    protected CommonFactory() {
        this.locatorFactory = LocatorTools.createLocalLocatorFactory(this, LocatorFactory.get());
    }

    protected T basicCreateInstance(IArgs args) throws ObjectCreationException {
        return null;
    }

    protected void basicCreateInstanceConfig(T object, IArgs args) throws ObjectCreationException {
        try {
            IElement configuration;
            ClassLoader classLoader = this.getClassLoader(args);
            boolean init = false;
            if (this.getInstanceConfiguration() != null) {
                init = true;
                if (object instanceof IElementConfigurable) {
                    ((IElementConfigurable)object).configure(this.getInstanceConfiguration());
                }
                ElementTools.setProperties(object, this.getInstanceConfiguration(), classLoader);
            }
            if ((configuration = this.getConfiguration(args)) != null) {
                init = true;
                if (object instanceof IElementConfigurable) {
                    ((IElementConfigurable)object).configure(configuration);
                }
                ElementTools.setProperties(object, configuration, classLoader);
            }
            if (init && object instanceof IInitializeable) {
                ((IInitializeable)object).initializeAfterConstruction();
            }
        }
        catch (ObjectCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
    }

    protected void basicCreateInstanceInit(T object, IArgs args) throws ObjectCreationException {
        Object context;
        ClassLoader classLoader = this.getClassLoader(args);
        if (classLoader != null && object instanceof IClassLoaderAccess) {
            ((IClassLoaderAccess)object).setClassLoader(classLoader);
        }
        if ((context = this.getContext(args)) != null && object instanceof IContextSupport) {
            try {
                ((IContextSupport)object).setContext(context);
            }
            catch (ConfigurationException e) {
                throw new ObjectCreationException(e);
            }
        }
        if (object instanceof IInitializeable) {
            ((IInitializeable)object).initializeAfterCreation();
        }
    }

    protected String basicGetDescription() {
        String key;
        MessageBundle bundle = MessageBundleTools.getMessageBundle(this.getMessageBundleClass());
        if (bundle.basicGetString(key = String.valueOf(ClassTools.getUnqualifiedName(this.getMessageBundleClass())) + ".description") != null) {
            return bundle.getMessage(key).get();
        }
        return this.getTip();
    }

    protected String basicGetLabel() {
        MessageBundle bundle = MessageBundleTools.getMessageBundle(this.getMessageBundleClass());
        return bundle.getMessage(String.valueOf(ClassTools.getUnqualifiedName(this.getMessageBundleClass())) + ".label").get();
    }

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        this.configuration = pElement;
        String tempId = this.configuration.attributeValue("id", null);
        if (tempId != null) {
            this.setId(tempId);
        }
        if (this.getCategory() == null) {
            String categoryId = this.configuration.attributeValue("category", null);
            this.setCategory(CategoryRegistry.get().lookupCategory(categoryId));
        }
        this.setInstanceConfiguration(this.configuration.element("instanceConfiguration"));
        this.setIconName(this.configuration.attributeValue("icon", null));
        IAttribute attribute = this.configuration.attribute("label");
        if (attribute != null) {
            this.setLabel(attribute.getData());
        }
        if ((attribute = this.configuration.attribute("tip")) != null) {
            this.setTip(attribute.getData());
        }
        if ((attribute = this.configuration.attribute("description")) != null) {
            this.setDescription(attribute.getData());
        }
        TagTools.configureTags(this, pElement);
    }

    @Override
    public final T createInstance(IArgs args) throws ObjectCreationException {
        T object = this.basicCreateInstance(args);
        this.basicCreateInstanceInit(object, args);
        this.basicCreateInstanceConfig(object, args);
        return object;
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public File getBaseDir() {
        return this.getFileEnvironment().getBaseDir();
    }

    @Override
    public ICategory getCategory() {
        return this.category;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.context instanceof IClassLoaderSupport) {
            return ((IClassLoaderSupport)this.context).getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    protected ClassLoader getClassLoader(IArgs args) {
        Object result = args.get(ARG_CLASSLOADER);
        return result instanceof ClassLoader ? (ClassLoader)result : this.getClassLoader();
    }

    protected IElement getConfiguration(IArgs args) {
        Object result = args.get(ARG_CONFIGURATION);
        return result instanceof IElement ? (IElement)result : null;
    }

    public Object getContext() {
        return this.context;
    }

    protected Object getContext(IArgs args) {
        Object result = args.get(ARG_CONTEXT);
        return result == null ? this.getContext() : result;
    }

    protected String getDefaultId() {
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            return this.basicGetDescription();
        }
        if (this.description instanceof Message) {
            this.description = ((Message)this.description).get();
        }
        return (String)this.description;
    }

    protected IFileEnvironment getFileEnvironment() {
        if (this.context instanceof IFileEnvironment) {
            return (IFileEnvironment)this.context;
        }
        return FileEnvironment.get();
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            return this.getDefaultId();
        }
        return this.id;
    }

    public IElement getInstanceConfiguration() {
        return this.instanceConfiguration;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            return this.basicGetLabel();
        }
        if (this.label instanceof Message) {
            this.label = ((Message)this.label).get();
        }
        return (String)this.label;
    }

    @Override
    public ILocatorFactory getLocatorFactory() {
        return this.locatorFactory;
    }

    protected Class getMessageBundleClass() {
        return this.getClass();
    }

    @Override
    public File getProfileDir() {
        return this.getFileEnvironment().getProfileDir();
    }

    @Override
    public File getTempDir() {
        return this.getFileEnvironment().getTempDir();
    }

    @Override
    public String getTip() {
        if (this.tip == null) {
            return this.getLabel();
        }
        if (this.tip instanceof Message) {
            this.tip = ((Message)this.tip).get();
        }
        return (String)this.tip;
    }

    @Override
    public File getWorkingDir() {
        return this.getFileEnvironment().getWorkingDir();
    }

    @Override
    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    protected void setCategory(ICategory category) {
        this.category = category;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        this.context = context;
    }

    public void setDescription(Object description) {
        this.description = description;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    protected void setId(String id) {
        this.id = id;
    }

    public void setInstanceConfiguration(IElement instanceConfiguration) {
        this.instanceConfiguration = instanceConfiguration;
    }

    public void setLabel(Object label) {
        this.label = label;
    }

    public void setTip(Object tip) {
        this.tip = tip;
    }

    public String toString() {
        return "factory " + this.getId();
    }
}

