/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.factory.ClassBasedFactory;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.factory.PACKAGE;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FactoryTools {
    private static final Logger Log = PACKAGE.Log;

    public static IFactory createFactory(Object value, Object defaultValue) throws ObjectCreationException {
        if (value == null) {
            value = defaultValue;
        }
        if (value instanceof IFactory) {
            return value;
        }
        if (value instanceof String) {
            value = FactoryTools.lookupFactory((String)((Object)value), null);
        }
        if (value instanceof Class) {
            value = FactoryTools.lookupFactory((Class)((Object)value));
        }
        throw new ObjectCreationException("can't create factory from " + StringTools.safeString(value));
    }

    public static <T extends IFactory<?>> T lookupFactory(Class<T> clazz) {
        String id = clazz.getName();
        ClassBasedFactory factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            try {
                if (IFactory.class.isAssignableFrom(clazz)) {
                    factory = ObjectTools.createObject(clazz, IFactory.class);
                    Outlet.get().registerFactory(factory);
                    Log.log(Level.INFO, "created default factory '" + id + "'");
                } else {
                    factory = new ClassBasedFactory(clazz);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (T)factory;
    }

    public static IFactory<?> lookupFactory(String id, ClassLoader classLoader) {
        ClassBasedFactory factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            try {
                Class<Object> clazz = ClassTools.createClass(id, Object.class, classLoader);
                if (IFactory.class.isAssignableFrom(clazz)) {
                    factory = ObjectTools.createObject(clazz, IFactory.class);
                    Outlet.get().registerFactory(factory);
                    Log.log(Level.INFO, "created default factory '" + id + "'");
                } else {
                    factory = new ClassBasedFactory(clazz);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return factory;
    }

    public static <T> IFactory<T> lookupFactoryFor(Class<T> clazz) {
        IFactory<T>[] factories = Outlet.get().lookupFactories(clazz);
        if (factories.length > 0) {
            return factories[0];
        }
        String id = String.valueOf(clazz.getName()) + "Factory";
        IFactory factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            try {
                factory = ObjectTools.createObject(id, IFactory.class, clazz.getClassLoader());
                Outlet.get().registerFactory(factory);
                Log.log(Level.INFO, "created default factory '" + id + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return factory;
    }
}

