/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.factory.CommonFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;

public class GenericFactory<T>
extends CommonFactory<T> {
    private IElement template;
    private Class resultClass = Object.class;

    @Override
    protected T basicCreateInstance(IArgs args) throws ObjectCreationException {
        return ElementTools.createObject(this.getTemplate(), this.resultClass, this.getContext(args));
    }

    @Override
    public void basicCreateInstanceInit(T object, IArgs args) {
    }

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        super.configure(pElement);
        this.setTemplate(pElement.element("template"));
        try {
            this.setResultClass(ElementTools.createClass(pElement, "resultClass", Object.class, this));
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException(e);
        }
    }

    public Class getResultClass() {
        return this.resultClass;
    }

    @Override
    public Class<T> getResultType() {
        return this.resultClass;
    }

    public IElement getTemplate() {
        return this.template;
    }

    public void setResultClass(Class resultClass) {
        if (resultClass == null) {
            resultClass = Object.class;
        }
        this.resultClass = resultClass;
    }

    public void setTemplate(IElement template) {
        this.template = template;
    }
}

