/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ArchiveTools {
    private static Map dumpDirs = new HashMap();
    private static final NumberFormat theFormat = NumberFormat.getNumberInstance();

    static {
        theFormat.setMaximumFractionDigits(0);
        theFormat.setMinimumIntegerDigits(19);
        theFormat.setGroupingUsed(false);
    }

    public static String archive(File root, String relativePath, File file, int max, String sourceEncoding, String destinationEncoding, boolean deleteSource, boolean forceArchive) throws IOException {
        File archive;
        if (max == 0 || root == null) {
            return null;
        }
        String dirName = FileTools.resolvePath(root, relativePath).getAbsolutePath();
        if (!forceArchive && dirName.equals(file.getParentFile().getAbsolutePath())) {
            archive = file;
        } else {
            DumpDirectory d = DumpDirectory.get(dirName);
            archive = d.getDumpFile(file.getName(), max);
            if (deleteSource) {
                FileTools.renameFile(file, sourceEncoding, archive, destinationEncoding);
            } else {
                FileTools.copyFile(file, sourceEncoding, archive, destinationEncoding);
            }
        }
        try {
            archive.setLastModified(System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return archive.getAbsolutePath();
    }

    public static String archive(File root, String relativePath, String filename, InputStream is, int max) throws IOException {
        if (max == 0 || root == null) {
            return null;
        }
        File archive = ArchiveTools.createArchive(root, relativePath, filename, max);
        FileOutputStream os = new FileOutputStream(archive);
        try {
            try {
                StreamTools.copyStream(is, os);
            }
            catch (Exception e) {
                throw new IOException("archiving failed (" + e.getMessage() + ")");
            }
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
        return archive.getAbsolutePath();
    }

    public static File createArchive(File root, String relativePath, String filename, int max) throws IOException {
        if (max == 0 || root == null) {
            return null;
        }
        String dirName = FileTools.resolvePath(root, relativePath).getAbsolutePath();
        DumpDirectory d = DumpDirectory.get(dirName);
        File archive = d.getDumpFile(filename, max);
        return archive;
    }

    public static OutputStream createOutputStream(File root, String filename, int max) throws IOException {
        if (max == 0 || root == null) {
            return null;
        }
        DumpDirectory d = DumpDirectory.get(root);
        File archive = d.getDumpFile(filename, max);
        return new FileOutputStream(archive);
    }

    static class DumpDirectory {
        File dir;
        int currentCount;
        int dirCount;
        long lastDump = System.currentTimeMillis();

        public static DumpDirectory get(File file) {
            return DumpDirectory.get(file.getAbsolutePath());
        }

        public static synchronized DumpDirectory get(String name) {
            DumpDirectory dd = (DumpDirectory)dumpDirs.get(name);
            if (dd == null) {
                dd = new DumpDirectory(new File(name));
                dd.prepare();
                dumpDirs.put(name, dd);
            }
            return dd;
        }

        protected DumpDirectory(File dir) {
            this.setDir(dir);
        }

        protected void checkDir() throws IOException {
            if (!this.getDir().exists() && !this.getDir().mkdirs()) {
                throw new IOException(" can't create temporary directory " + this.getDir());
            }
        }

        protected void checkFiles(int max) throws IOException {
            if (max <= 0 || this.currentCount <= max) {
                return;
            }
            Object[] fileNames = this.dir.list();
            if (fileNames == null) {
                throw new IOException("can not list directory " + this.dir.getAbsolutePath());
            }
            if (fileNames.length != this.dirCount + this.currentCount) {
                this.prepare((String[])fileNames);
            }
            Arrays.sort(fileNames);
            int delete = Math.min(fileNames.length, this.currentCount - max);
            int i = 0;
            while (i < delete) {
                File deleteFile = new File(this.dir, (String)fileNames[i]);
                if (deleteFile.isFile()) {
                    if (!deleteFile.delete()) {
                        throw new IOException("can not delete file " + deleteFile.getAbsolutePath());
                    }
                    --this.currentCount;
                }
                ++i;
            }
        }

        public File getDir() {
            return this.dir;
        }

        public synchronized File getDumpFile(String name, int max) throws IOException {
            File newFile = new File(this.getDir(), String.valueOf(this.getUniquePrefix()) + "." + name);
            this.checkDir();
            if (!newFile.createNewFile()) {
                throw new IOException("can not create file " + newFile.getAbsolutePath());
            }
            ++this.currentCount;
            try {
                this.checkFiles(max);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return newFile;
        }

        public long getLastDump() {
            return this.lastDump;
        }

        protected long getUniqueMillis() {
            long current = System.currentTimeMillis();
            while (this.getLastDump() >= current) {
                ++current;
            }
            this.setLastDump(current);
            return current;
        }

        protected String getUniquePrefix() {
            return theFormat.format(this.getUniqueMillis());
        }

        protected void prepare() {
            String[] fileNames = this.dir.list();
            if (fileNames == null) {
                return;
            }
            this.prepare(fileNames);
        }

        protected void prepare(String[] fileNames) {
            this.currentCount = 0;
            this.dirCount = 0;
            if (fileNames != null) {
                int i = 0;
                while (i < fileNames.length) {
                    File f = new File(this.dir, fileNames[i]);
                    if (f.isFile()) {
                        ++this.currentCount;
                    } else {
                        ++this.dirCount;
                    }
                    ++i;
                }
            }
        }

        private void setDir(File newDir) {
            this.dir = newDir;
        }

        private void setLastDump(long newLastDump) {
            this.lastDump = newLastDump;
        }
    }
}

