/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.attachment.Attachment;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileAttachmentTools {
    private static final Logger Log = LogTools.getLogger(FileTools.class);

    protected static String createAttachmentName(String masterName, String movedName, String attachName) {
        String prefix = StringTools.getCommonPrefix(masterName, attachName, true);
        if (StringTools.isEmpty(prefix)) {
            return attachName;
        }
        int masterSuffixLength = masterName.length() - prefix.length();
        int attachSuffixLength = attachName.length() - prefix.length();
        String newName = movedName;
        newName = newName.substring(0, newName.length() - masterSuffixLength);
        newName = String.valueOf(newName) + attachName.substring(attachName.length() - attachSuffixLength);
        return newName;
    }

    public static List createAttachments(File master, File[] files, String extensions) {
        if (StringTools.isEmpty(extensions)) {
            return Collections.EMPTY_LIST;
        }
        String masterName = null;
        String masterBaseName = null;
        if (master != null) {
            masterName = master.getName().toLowerCase();
            masterBaseName = FileTools.getBaseName(masterName);
        }
        ArrayList<File> result = new ArrayList<File>();
        String[] tempExtensions = extensions.toLowerCase().split(";");
        int j = 0;
        while (j < files.length) {
            File checkFile = files[j];
            String checkFileName = checkFile.getName().toLowerCase();
            if (!checkFileName.equals(masterName)) {
                String checkFileBaseName = FileTools.getBaseName(checkFileName);
                if (master == null || checkFileBaseName.equals(masterName) || checkFileBaseName.equals(masterBaseName)) {
                    int i = 0;
                    while (i < tempExtensions.length) {
                        String tempExtension = tempExtensions[i].trim();
                        boolean required = tempExtension.startsWith("+");
                        if (required) {
                            tempExtension = tempExtension.substring(1);
                        }
                        if (checkFileName.endsWith(tempExtension)) {
                            result.add(checkFile);
                            break;
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
        return result;
    }

    public static List createAttachments(File master, String extensions) {
        File tempFile;
        File tempDir;
        if (master.isDirectory()) {
            tempDir = master;
            tempFile = null;
        } else {
            tempDir = master.getParentFile();
            tempFile = master;
        }
        if (tempDir == null) {
            return null;
        }
        File[] files = tempDir.listFiles();
        return FileAttachmentTools.createAttachments(tempFile, files, extensions);
    }

    public static void deleteAttachments(List attachments) {
        for (Object attachment : attachments) {
            ILocator tempLocator;
            if (attachment instanceof Attachment) {
                attachment = ((Attachment)attachment).getAttached();
            }
            if (attachment instanceof File) {
                if (!((File)attachment).exists() || ((File)attachment).delete()) continue;
                Log.log(Level.WARNING, "deleting '" + attachment + "' failed");
                continue;
            }
            if (attachment instanceof ILocator) {
                if (!((ILocator)attachment).exists()) continue;
                try {
                    ((ILocator)attachment).delete();
                }
                catch (IOException e) {
                    Log.log(Level.WARNING, "deleting '" + attachment + "' failed");
                }
                continue;
            }
            if (!(attachment instanceof ILocatorSupport) || !(tempLocator = ((ILocatorSupport)attachment).getLocator()).exists()) continue;
            try {
                tempLocator.delete();
            }
            catch (IOException e) {
                Log.log(Level.WARNING, "deleting '" + tempLocator + "' failed");
            }
        }
    }

    public static boolean existsAttachments(File master, File[] files, String extensions) {
        if (StringTools.isEmpty(extensions)) {
            return true;
        }
        String masterName = null;
        String masterBaseName = null;
        if (master != null) {
            masterName = master.getName().toLowerCase();
            masterBaseName = FileTools.getBaseName(masterName);
        }
        String[] tempExtensions = extensions.toLowerCase().split(";");
        int i = 0;
        while (i < tempExtensions.length) {
            String tempExtension = tempExtensions[i].trim();
            boolean required = tempExtension.startsWith("+");
            if (required) {
                tempExtension = tempExtension.substring(1);
                boolean exists = false;
                int j = 0;
                while (j < files.length) {
                    File checkFile = files[j];
                    String checkFileName = checkFile.getName().toLowerCase();
                    String checkFileBaseName = FileTools.getBaseName(checkFileName);
                    if ((master == null || checkFileBaseName.equals(masterName) || checkFileBaseName.equals(masterBaseName)) && checkFileName.endsWith(tempExtension)) {
                        exists = true;
                        break;
                    }
                    ++j;
                }
                if (!exists) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean isAttachment(File file, String extensions) {
        if (StringTools.isEmpty(extensions)) {
            return false;
        }
        String fileName = file.getName().toLowerCase();
        String[] tempFilters = extensions.toLowerCase().split(";");
        int i = 0;
        while (i < tempFilters.length) {
            String tempFilter = tempFilters[i].trim();
            boolean required = tempFilter.startsWith("+");
            if (required) {
                tempFilter = tempFilter.substring(1);
            }
            if (fileName.endsWith(tempFilter)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static File moveAttachment(File master, File attachment, File movedFile, boolean delete) throws IOException {
        return FileAttachmentTools.moveAttachment(master, attachment, movedFile, delete, false);
    }

    public static File moveAttachment(File master, File attachment, File movedFile, boolean delete, boolean keepLastModified) throws IOException {
        if (master == null || movedFile == null || attachment == null) {
            return attachment;
        }
        String masterName = master.getName();
        String movedName = movedFile.getName();
        File movedDir = movedFile.isDirectory() ? movedFile : movedFile.getParentFile();
        if (movedDir == null) {
            return attachment;
        }
        File movedAttachment = FileAttachmentTools.moveAttachment(masterName, attachment, movedName, movedDir, delete, keepLastModified);
        return movedAttachment;
    }

    protected static File moveAttachment(String masterName, Object attachment, String movedName, File dir, boolean delete, boolean keepLastModified) throws IOException {
        if (attachment instanceof Attachment) {
            attachment = ((Attachment)attachment).getAttached();
        }
        if (attachment instanceof ILocatorSupport) {
            attachment = ((ILocatorSupport)attachment).getLocator();
        }
        if (attachment instanceof FileLocator) {
            attachment = ((FileLocator)attachment).getFile();
        }
        try {
            if (attachment instanceof File) {
                File tempFile = (File)attachment;
                if (tempFile.exists()) {
                    long lastModified = 0L;
                    if (keepLastModified) {
                        lastModified = tempFile.lastModified();
                    }
                    String tempName = tempFile.getName();
                    String newName = FileAttachmentTools.createAttachmentName(masterName, movedName, tempName);
                    File newAttachment = new File(dir, newName);
                    if (delete) {
                        if (Log.isLoggable(Level.FINE)) {
                            Log.log(Level.FINE, "move '" + tempFile.getAbsolutePath() + "' to '" + newAttachment.getAbsolutePath() + "'");
                        }
                        FileTools.renameFile(tempFile, newAttachment);
                    } else {
                        if (Log.isLoggable(Level.FINE)) {
                            Log.log(Level.FINE, "copy '" + tempFile.getAbsolutePath() + "' to '" + newAttachment.getAbsolutePath() + "'");
                        }
                        FileTools.copyFile(tempFile, newAttachment);
                    }
                    if (lastModified != 0L) {
                        newAttachment.setLastModified(lastModified);
                    }
                    return newAttachment;
                }
                Log.log(Level.FINE, "attachment '" + tempFile.getAbsolutePath() + "' no longer available");
            }
            if (attachment instanceof ILocator) {
                ILocator tempLocator = (ILocator)attachment;
                if (tempLocator.exists()) {
                    String tempName = tempLocator.getTypedName();
                    String newName = FileAttachmentTools.createAttachmentName(masterName, movedName, tempName);
                    File newAttachment = new File(dir, newName);
                    if (Log.isLoggable(Level.FINE)) {
                        Log.log(Level.FINE, "create file '" + newAttachment.getAbsolutePath() + "'");
                    }
                    InputStream source = null;
                    FileOutputStream destination = null;
                    try {
                        source = tempLocator.getInputStream();
                        destination = new FileOutputStream(newAttachment);
                        StreamTools.copyStream(source, destination);
                    }
                    catch (Throwable throwable) {
                        StreamTools.close(source);
                        StreamTools.close(destination);
                        throw throwable;
                    }
                    StreamTools.close(source);
                    StreamTools.close(destination);
                    if (delete) {
                        if (Log.isLoggable(Level.FINE)) {
                            Log.log(Level.FINE, "delete locator '" + tempLocator.getFullName() + "'");
                        }
                        tempLocator.delete();
                    }
                    return newAttachment;
                }
                Log.log(Level.FINE, "attachment '" + tempLocator.getFullName() + "' no longer available");
            }
            return null;
        }
        catch (Exception e) {
            throw new IOException("failed to move attachment '" + String.valueOf(attachment) + "' attached to '" + masterName + "' (" + e.getMessage() + ")");
        }
    }

    public static List moveAttachments(File master, List attachments, File movedFile, boolean delete) throws IOException {
        return FileAttachmentTools.moveAttachments(master, attachments, movedFile, delete, false);
    }

    public static List moveAttachments(File master, List attachments, File movedFile, boolean delete, boolean keepLastModified) throws IOException {
        if (master == null || movedFile == null || attachments == null || attachments.isEmpty()) {
            return attachments;
        }
        ArrayList<File> result = new ArrayList<File>();
        String masterName = master.getName();
        String movedName = movedFile.getName();
        File movedDir = movedFile.isDirectory() ? movedFile : movedFile.getParentFile();
        if (movedDir == null) {
            return attachments;
        }
        IOException ex = null;
        for (Object tempAttachment : attachments) {
            try {
                File movedAttachment = FileAttachmentTools.moveAttachment(masterName, tempAttachment, movedName, movedDir, delete, keepLastModified);
                if (movedAttachment == null) continue;
                result.add(movedAttachment);
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return result;
    }
}

