/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.attachment.Attachment;
import de.intarsys.tools.expression.CacheResolver;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.file.CollisionException;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.FilenameResolver;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileGroup {
    private File master;
    private File root;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private static final Logger Log = LogTools.getLogger(FileGroup.class);

    public FileGroup(File master) {
        this.master = master;
    }

    public FileGroup(File root, File master) {
        this.root = root;
        this.master = master;
    }

    protected File createTargetFile(File dir, File file, String template, IStringEvaluator resolver) throws IOException {
        String tempName;
        String extensionPrefix = FileTools.getExtension(this.master);
        MapResolver filenameResolver = new MapResolver().define("file", new FilenameResolver(file, extensionPrefix));
        TaggedStringEvaluator evaluator = TaggedStringEvaluator.decorate(filenameResolver, resolver);
        try {
            tempName = (String)evaluator.evaluate(template, Args.create());
        }
        catch (Exception ee) {
            tempName = template;
        }
        tempName = FileTools.trimPath(tempName);
        File tempFile = FileTools.resolvePath(dir, tempName);
        File parentFile = tempFile.getParentFile();
        if (parentFile != null) {
            FileTools.checkDirectory(parentFile, true, true, true);
        }
        return tempFile;
    }

    protected File createTargetFile(File destination, Object item, String template, IStringEvaluator resolver) throws IOException {
        Object temp = item;
        if (temp instanceof Attachment) {
            temp = ((Attachment)item).getAttached();
        }
        if (temp instanceof ILocatorSupport) {
            temp = ((ILocatorSupport)temp).getLocator();
        }
        if (temp instanceof FileLocator) {
            temp = ((FileLocator)temp).getFile();
        }
        if (temp instanceof File) {
            File tempFile = (File)temp;
            return this.createTargetFile(destination, tempFile, template, resolver);
        }
        if (temp instanceof ILocator) {
            ILocator tempLocator = (ILocator)temp;
            return this.createTargetFile(destination, new File(tempLocator.getFullName()), template, resolver);
        }
        return null;
    }

    public void delete() throws IOException {
        for (Attachment attachment : this.attachments) {
            this.delete(attachment);
        }
        this.delete(this.master);
    }

    protected void delete(Object item) throws IOException {
        Object temp = item;
        if (temp instanceof Attachment) {
            temp = ((Attachment)temp).getAttached();
        }
        if (temp instanceof ILocatorSupport) {
            temp = ((ILocatorSupport)temp).getLocator();
        }
        if (temp instanceof FileLocator) {
            temp = ((FileLocator)temp).getFile();
        }
        if (temp instanceof File) {
            File tempFile = (File)temp;
            if (tempFile.exists()) {
                FileTools.delete(tempFile);
            } else if (Log.isLoggable(Level.FINE)) {
                Log.log(Level.FINE, "file group item '" + tempFile.getAbsolutePath() + "' no longer available");
            }
        }
        if (temp instanceof ILocator) {
            ILocator tempLocator = (ILocator)temp;
            if (tempLocator.exists()) {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.log(Level.FINEST, "locator move delete '" + tempLocator.getFullName() + "'");
                }
                tempLocator.delete();
            } else {
                Log.log(Level.FINE, "file group item '" + tempLocator.getFullName() + "' no longer available");
            }
        }
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public File getMaster() {
        return this.master;
    }

    public File getRoot() {
        return this.root;
    }

    public void move(File targetDir, String template, IStringEvaluator resolver, boolean deleteSource, boolean deleteSubdirectories, boolean keepLastModified, boolean collisionDetect) throws IOException {
        CacheResolver cacheResolver = new CacheResolver(resolver);
        FileTools.Lock lock = null;
        try {
            File masterTarget = this.createTargetFile(targetDir, this.master, template, (IStringEvaluator)cacheResolver);
            if (masterTarget.equals(this.master)) {
                return;
            }
            if (collisionDetect && masterTarget.exists()) {
                throw new CollisionException("'" + masterTarget + "' exists");
            }
            lock = FileTools.lock(masterTarget);
            if (collisionDetect && lock == null) {
                throw new CollisionException("'" + masterTarget + "' locked");
            }
            for (Attachment attachment : this.attachments) {
                File attachTarget = this.createTargetFile(targetDir, attachment, template, (IStringEvaluator)cacheResolver);
                if (!collisionDetect || !attachTarget.exists()) continue;
                throw new CollisionException("'" + attachTarget + "' exists");
            }
            ArrayList<Attachment> tempAttachments = new ArrayList<Attachment>();
            for (Attachment attachment : this.attachments) {
                File attachTarget = this.createTargetFile(targetDir, attachment, template, (IStringEvaluator)cacheResolver);
                Attachment tempAttachment = this.move(attachment, attachTarget, deleteSource, keepLastModified);
                tempAttachments.add(tempAttachment);
            }
            if (masterTarget.exists()) {
                if (deleteSource) {
                    FileTools.delete(this.master);
                }
            } else {
                this.move(this.master, masterTarget, deleteSource, keepLastModified);
            }
            if (deleteSubdirectories) {
                FileTools.deleteEmptyDirectories(this.getRoot(), this.master);
            }
            this.attachments = tempAttachments;
            this.master = masterTarget;
            this.root = targetDir;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    protected Attachment move(Object item, File target, boolean deleteSource, boolean keepLastModified) throws IOException {
        Object temp = item;
        Attachment attachment = null;
        if (temp instanceof Attachment) {
            attachment = (Attachment)temp;
            temp = ((Attachment)temp).getAttached();
        }
        if (temp instanceof ILocatorSupport) {
            temp = ((ILocatorSupport)temp).getLocator();
        }
        if (temp instanceof FileLocator) {
            temp = ((FileLocator)temp).getFile();
        }
        if (temp instanceof File) {
            File tempFile = (File)temp;
            if (tempFile.exists()) {
                if (deleteSource) {
                    long lastModified = 0L;
                    if (keepLastModified) {
                        lastModified = tempFile.lastModified();
                    }
                    FileTools.renameFile(tempFile, target);
                    if (lastModified != 0L) {
                        target.setLastModified(lastModified);
                    }
                } else {
                    FileTools.copyFile(tempFile, target);
                }
                return new Attachment(target.getName(), target);
            }
            if (Log.isLoggable(Level.FINE)) {
                Log.log(Level.FINE, "file group item '" + tempFile.getAbsolutePath() + "' no longer available");
            }
            return null;
        }
        if (temp instanceof ILocator) {
            ILocator tempLocator = (ILocator)temp;
            if (tempLocator.exists()) {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.log(Level.FINEST, "locator move create target file '" + target.getAbsolutePath() + "'");
                }
                InputStream is = null;
                FileOutputStream os = null;
                try {
                    try {
                        is = tempLocator.getInputStream();
                        os = new FileOutputStream(target);
                        StreamTools.copyStream(is, os);
                        if (Log.isLoggable(Level.FINEST)) {
                            Log.log(Level.FINEST, "locator move success");
                        }
                    }
                    catch (Exception e) {
                        if (Log.isLoggable(Level.FINE)) {
                            Log.log(Level.FINE, "locator move failed");
                        }
                        throw new IOException("locator move failed for '" + tempLocator.getFullName() + "' to '" + target.getAbsolutePath() + "'", e);
                    }
                }
                catch (Throwable throwable) {
                    StreamTools.close(is);
                    StreamTools.close(os);
                    throw throwable;
                }
                StreamTools.close(is);
                StreamTools.close(os);
                if (deleteSource) {
                    if (Log.isLoggable(Level.FINEST)) {
                        Log.log(Level.FINEST, "locator move delete '" + tempLocator.getFullName() + "'");
                    }
                    tempLocator.delete();
                }
                return new Attachment(target.getName(), target);
            }
            Log.log(Level.FINE, "file group item '" + tempLocator.getFullName() + "' no longer available");
            return null;
        }
        return attachment;
    }
}

