/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.dom.PACKAGE;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileSnapshot {
    private static final Logger Log = PACKAGE.Log;
    private final File file;
    private List<FileSnapshot> children;
    private final boolean directory;
    private long fileLength = 0L;
    private long lastModified = 0L;

    public FileSnapshot(File file) {
        this.file = file;
        this.directory = file.isDirectory();
        this.updateLocal(file.length(), file.lastModified());
        File[] tempFiles = file.listFiles();
        if (tempFiles != null) {
            this.updateChildren(Arrays.asList(tempFiles));
        }
    }

    public FileSnapshot[] getChildren() {
        if (this.children == null) {
            return null;
        }
        return this.children.toArray(new FileSnapshot[this.children.size()]);
    }

    public File getFile() {
        return this.file;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    /*
     * Loose catch block
     */
    public boolean isAvailable() {
        block23: {
            FileLock lock;
            FileOutputStream os;
            block21: {
                block22: {
                    if (Log.isLoggable(Level.FINEST)) {
                        Log.log(Level.FINEST, "checking availability of file " + this.getFile().getAbsolutePath());
                    }
                    if (this.children != null) {
                        for (FileSnapshot child : this.children) {
                            if (child.isAvailable()) continue;
                            return false;
                        }
                        return true;
                    }
                    if (!this.getFile().exists()) {
                        return true;
                    }
                    os = null;
                    lock = null;
                    os = new FileOutputStream(this.getFile(), true);
                    lock = os.getChannel().tryLock();
                    if (lock == null) break block21;
                    if (Log.isLoggable(Level.FINEST)) {
                        Log.log(Level.FINEST, "file " + this.getFile().getAbsolutePath() + " available");
                    }
                    if (lock == null) break block22;
                    try {
                        lock.release();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                StreamTools.close(os);
                return true;
                catch (Exception exception) {
                    if (lock != null) {
                        try {
                            lock.release();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    StreamTools.close(os);
                    break block23;
                    catch (Throwable throwable) {
                        if (lock != null) {
                            try {
                                lock.release();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        StreamTools.close(os);
                        throw throwable;
                    }
                }
            }
            if (lock != null) {
                try {
                    lock.release();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            StreamTools.close(os);
        }
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "file " + this.getFile().getAbsolutePath() + " not available");
        }
        return false;
    }

    public boolean isChanged() {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "checking file " + this.getFile().getAbsolutePath() + " for changes");
        }
        long newLastModified = this.getFile().lastModified();
        long newLength = this.getFile().length();
        File[] tempFiles = this.getFile().listFiles();
        ArrayList<File> newFiles = tempFiles == null ? null : new ArrayList<File>(Arrays.asList(tempFiles));
        boolean exists = this.getFile().exists();
        if (!exists) {
            this.children = null;
            return true;
        }
        boolean changed = false;
        if (this.children != null) {
            Iterator<FileSnapshot> it = this.children.iterator();
            while (it.hasNext()) {
                FileSnapshot child = it.next();
                if (child.isChanged()) {
                    changed = true;
                    if (child.isLost()) {
                        it.remove();
                    }
                }
                if (newFiles == null) continue;
                newFiles.remove(child.getFile());
            }
        }
        if (newFiles != null && newFiles.size() > 0) {
            this.updateChildren(newFiles);
            changed = true;
        }
        if (newLastModified != this.lastModified || newLength != this.fileLength) {
            this.updateLocal(newLength, newLastModified);
            changed = true;
        }
        if (Log.isLoggable(Level.FINEST)) {
            if (changed) {
                Log.log(Level.FINEST, "file " + this.getFile().getAbsolutePath() + " changed");
            } else {
                Log.log(Level.FINEST, "file " + this.getFile().getAbsolutePath() + " unchanged");
            }
        }
        return changed;
    }

    public boolean isLost() {
        return !this.getFile().exists();
    }

    protected void updateChildren(List<File> newFiles) {
        if (this.children == null) {
            this.children = new ArrayList<FileSnapshot>();
        }
        for (File file : newFiles) {
            this.children.add(new FileSnapshot(file));
        }
    }

    protected void updateLocal(long newLength, long newModified) {
        this.fileLength = newLength;
        this.lastModified = newModified;
    }
}

