/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.system.SystemTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileTools {
    public static final String DIRECTORY_LOCK = "directory.lock";
    private static final Logger Log = LogTools.getLogger(FileTools.class);
    private static Map<File, Lock> maps = new HashMap<File, Lock>();

    public static void appendFile(File source, File destination) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        if (FileTools.equalsOnSystem(source, destination)) {
            return;
        }
        try {
            try {
                is = new FileInputStream(source);
                os = new FileOutputStream(destination, true);
                StreamTools.copyStream(is, false, os, false);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("copying failed (" + e.getMessage() + ")");
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(is);
        StreamTools.close(os);
    }

    public static File checkDirectory(File dir, boolean create, boolean checkCanRead, boolean checkCanWrite) throws IOException {
        if (dir == null) {
            return dir;
        }
        if (!dir.exists() && create) {
            dir.mkdirs();
        }
        if (!dir.exists()) {
            throw new IOException("Can't create directory " + dir.getPath());
        }
        if (!dir.isDirectory()) {
            throw new IOException("Can't create directory " + dir.getPath());
        }
        if (checkCanRead && !dir.canRead()) {
            throw new IOException("No read access for directory " + dir.getPath());
        }
        if (checkCanWrite && !dir.canWrite()) {
            throw new IOException("No write access for directory " + dir.getPath());
        }
        return dir;
    }

    public static File checkDirectory(String path, boolean create, boolean checkCanRead, boolean checkCanWrite) throws IOException {
        if (StringTools.isEmpty(path)) {
            return null;
        }
        return FileTools.checkDirectory(new File(path), create, checkCanRead, checkCanWrite);
    }

    public static void copyBinaryFile(File source, File destination) throws IOException {
        if (destination.isDirectory()) {
            destination = new File(destination, source.getName());
        }
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "copy binary '" + source.getAbsolutePath() + "' to '" + destination.getAbsolutePath() + "'");
        }
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            if (Log.isLoggable(Level.FINEST)) {
                Log.log(Level.FINEST, "make directories for '" + destination.getAbsolutePath() + "'");
            }
            destination.getParentFile().mkdirs();
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            try {
                is = new FileInputStream(source);
                os = new FileOutputStream(destination);
                StreamTools.copyStream(is, os);
                if (Log.isLoggable(Level.FINEST)) {
                    Log.log(Level.FINEST, "copy binary success");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                if (Log.isLoggable(Level.FINE)) {
                    Log.log(Level.FINE, "copy binary failed");
                }
                throw new IOException("copy binary failed for '" + source.getAbsolutePath() + "' to '" + destination.getAbsolutePath() + "'", e);
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(is);
        StreamTools.close(os);
        destination.setLastModified(source.lastModified());
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileTools.copyBinaryFile(source, destination);
    }

    public static void copyFile(File source, String sourceEncoding, File destination, String destinationEncoding) throws IOException {
        if (sourceEncoding == null || destinationEncoding == null || sourceEncoding.equals(destinationEncoding)) {
            FileTools.copyBinaryFile(source, destination);
            return;
        }
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "copy encoded '" + source.getAbsolutePath() + "' to '" + destination.getAbsolutePath() + "'");
        }
        if (destination.isDirectory()) {
            destination = new File(destination, source.getName());
        }
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            if (Log.isLoggable(Level.FINEST)) {
                Log.log(Level.FINEST, "make directories for '" + destination.getAbsolutePath() + "'");
            }
            destination.getParentFile().mkdirs();
        }
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            try {
                is = new FileInputStream(source);
                os = new FileOutputStream(destination);
                StreamTools.copyEncodedStream(is, sourceEncoding, os, destinationEncoding);
                if (Log.isLoggable(Level.FINEST)) {
                    Log.log(Level.FINEST, "copy encoded success");
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                if (Log.isLoggable(Level.FINE)) {
                    Log.log(Level.FINE, "copy encoded failed");
                }
                throw new IOException("copy encoded failed for '" + source.getAbsolutePath() + "' to '" + destination.getAbsolutePath() + "'", e);
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(is);
        StreamTools.close(os);
        destination.setLastModified(source.lastModified());
    }

    public static void copyRecursively(File source, File destination) throws IOException {
        if (source.isFile()) {
            FileTools.copyFile(source, destination);
            return;
        }
        if (!source.isDirectory()) {
            throw new IOException("file '" + source.getAbsolutePath() + "' does not exist.");
        }
        if (destination.isFile()) {
            throw new IOException("cannot copy directory into file");
        }
        destination.mkdirs();
        String[] content = source.list();
        int i = 0;
        while (i < content.length) {
            FileTools.copyRecursively(new File(source, content[i]), new File(destination, content[i]));
            ++i;
        }
    }

    public static File copyRecursivelyInto(File source, File destinationParent, String newName) throws IOException {
        if (destinationParent.isFile()) {
            throw new IOException("can't copy into file");
        }
        String destinationName = newName == null ? source.getName() : newName;
        File destinationFile = new File(destinationParent, destinationName);
        if (source.equals(destinationFile)) {
            return destinationFile;
        }
        if (source.isFile()) {
            FileTools.copyFile(source, destinationFile);
            return destinationFile;
        }
        if (!source.isDirectory()) {
            throw new IOException("file '" + source.getAbsolutePath() + "' does not exist.");
        }
        String[] content = source.list();
        destinationFile.mkdirs();
        int i = 0;
        while (i < content.length) {
            FileTools.copyRecursivelyInto(new File(source, content[i]), destinationFile, content[i]);
            ++i;
        }
        return destinationFile;
    }

    public static void createEmptyFile(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        StreamTools.close(os);
    }

    public static File createTempFile(File file) throws IOException {
        String extension;
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            extension = name.substring(index);
            name = name.substring(0, index);
        } else {
            extension = "";
        }
        if (name.length() < 3) {
            name = "tmp" + name;
        }
        return TempTools.createTempFile(name, extension);
    }

    public static File createTempFile(String filename) throws IOException {
        return FileTools.createTempFile(new File(filename));
    }

    public static void delete(File master) throws IOException {
        if (!master.exists()) {
            if (Log.isLoggable(Level.FINEST)) {
                Log.log(Level.FINEST, "delete skipped for non existing '" + master.getAbsolutePath() + "'");
            }
            return;
        }
        if (master.delete()) {
            if (Log.isLoggable(Level.FINEST)) {
                Log.log(Level.FINEST, "deleted '" + master.getAbsolutePath() + "'");
            }
        } else {
            if (Log.isLoggable(Level.FINE)) {
                Log.log(Level.FINE, "delete failed for '" + master.getAbsolutePath() + "'");
            }
            throw new IOException("delete failed for '" + master.getAbsolutePath() + "'");
        }
    }

    public static void deleteAfter(File directory, long millis, boolean recursiveScan) throws IOException {
        if (millis <= 0L) {
            return;
        }
        String[] fileNames = directory.list();
        if (fileNames == null) {
            throw new IOException("cannot list " + directory);
        }
        long checkMillis = System.currentTimeMillis() - millis;
        int j = 0;
        while (j < fileNames.length) {
            File file = new File(directory, fileNames[j]);
            if (file.isDirectory() && recursiveScan) {
                FileTools.deleteAfter(file, millis, recursiveScan);
            }
            if (file.lastModified() < checkMillis) {
                file.delete();
            }
            ++j;
        }
    }

    public static void deleteEmptyDirectories(File root, File file) {
        File[] files;
        if (file == null || file.equals(root)) {
            return;
        }
        File dir = null;
        dir = file.isDirectory() ? file : file.getParentFile();
        if (dir != null && (files = dir.listFiles()) != null && files.length == 0 && dir.delete()) {
            FileTools.deleteEmptyDirectories(root, dir.getParentFile());
        }
    }

    public static boolean deleteRecursivly(File file) {
        return FileTools.deleteRecursivly(file, true);
    }

    public static boolean deleteRecursivly(File file, boolean deleteRoot) {
        if (file == null || !file.exists()) {
            return true;
        }
        if (file.isFile()) {
            return file.delete();
        }
        String[] files = file.list();
        if (files == null) {
            return false;
        }
        int i = 0;
        while (i < files.length) {
            if (!FileTools.deleteRecursivly(new File(file, files[i]))) {
                return false;
            }
            ++i;
        }
        if (deleteRoot) {
            return file.delete();
        }
        return true;
    }

    public static boolean equalsOnSystem(File source, File destination) {
        try {
            if (FileTools.isWindows()) {
                return source.getCanonicalPath().equalsIgnoreCase(destination.getCanonicalPath());
            }
            return source.getCanonicalPath().equals(destination.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getBaseName(File file) {
        if (file == null) {
            return FileTools.getBaseName(null, null, "");
        }
        return FileTools.getBaseName(file.getName(), null, "");
    }

    public static String getBaseName(String filename) {
        return FileTools.getBaseName(filename, null, "");
    }

    public static String getBaseName(String filename, String extensionPrefix, String defaultName) {
        int dotPos;
        int pos2;
        if (StringTools.isEmpty(filename)) {
            return defaultName;
        }
        int pos1 = filename.lastIndexOf(47);
        int pos = Math.max(pos1, pos2 = filename.lastIndexOf(92));
        if (pos >= 0) {
            filename = filename.substring(pos + 1);
        }
        if ((dotPos = filename.lastIndexOf(46)) >= 1) {
            filename = filename.substring(0, dotPos);
            if (extensionPrefix != null && filename.endsWith("." + extensionPrefix)) {
                filename = filename.substring(0, filename.length() - extensionPrefix.length() - 1);
            }
        }
        return filename;
    }

    public static String getEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getExtension(File file) {
        return FileTools.getExtension(file.getName(), null, "");
    }

    public static String getExtension(String filename) {
        return FileTools.getExtension(filename, null, "");
    }

    public static String getExtension(String filename, String extensionPrefix, String defaultName) {
        int dotPos;
        int pos2;
        if (StringTools.isEmpty(filename)) {
            return defaultName;
        }
        int pos1 = filename.lastIndexOf(47);
        int pos = Math.max(pos1, pos2 = filename.lastIndexOf(92));
        if (pos >= 0) {
            filename = filename.substring(pos + 1);
        }
        if ((dotPos = filename.lastIndexOf(46)) >= 1) {
            String temp = filename.substring(dotPos + 1);
            int extPos = filename.lastIndexOf("." + extensionPrefix);
            if (extensionPrefix != null && extPos >= 1 && extPos == dotPos - extensionPrefix.length() - 1) {
                temp = String.valueOf(extensionPrefix) + "." + temp;
            }
            return temp;
        }
        return defaultName;
    }

    public static String getFileName(File file) {
        return FileTools.getFileName(file.getName(), "");
    }

    public static String getFileName(String filename) {
        return FileTools.getFileName(filename, "");
    }

    public static String getFileName(String filename, String defaultName) {
        int pos2;
        if (StringTools.isEmpty(filename)) {
            return defaultName;
        }
        int pos1 = filename.lastIndexOf(47);
        int pos = Math.max(pos1, pos2 = filename.lastIndexOf(92));
        if (pos >= 0) {
            filename = filename.substring(pos + 1);
        }
        return filename;
    }

    protected static File getLockFile(File file) {
        File lockFile = null;
        lockFile = !file.exists() || file.isFile() ? new File(String.valueOf(file.getAbsolutePath()) + ".lock") : new File(file, DIRECTORY_LOCK);
        return lockFile;
    }

    public static File getParentFile(File file) {
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            parentFile = file.getAbsoluteFile().getParentFile();
        }
        if (parentFile == null) {
            return null;
        }
        return parentFile;
    }

    private static List getPathList(File f) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        File r = f.getCanonicalFile();
        while (r != null) {
            if (r.getName().length() == 0) {
                int dblptIndex = r.getPath().indexOf(":");
                if (dblptIndex == -1) {
                    l.add("");
                } else {
                    l.add(r.getPath().substring(0, dblptIndex));
                }
            } else {
                l.add(r.getName());
            }
            r = r.getParentFile();
        }
        ArrayList reversed = new ArrayList();
        int i = l.size() - 1;
        while (i >= 0) {
            reversed.add(l.get(i));
            --i;
        }
        return reversed;
    }

    public static String getPathName(File file) {
        return FileTools.getPathName(file.getPath(), "");
    }

    public static String getPathName(String filename) {
        return FileTools.getPathName(filename, "");
    }

    public static String getPathName(String filename, String defaultName) {
        int pos2;
        if (StringTools.isEmpty(filename)) {
            return defaultName;
        }
        int pos1 = filename.lastIndexOf(47);
        int pos = Math.max(pos1, pos2 = filename.lastIndexOf(92));
        if (pos < 0) {
            return defaultName;
        }
        filename = filename.substring(0, pos);
        if (StringTools.isEmpty(filename)) {
            return File.separator;
        }
        return filename;
    }

    public static String getPathRelativeTo(File file, File base) throws IOException {
        String relativePath = null;
        if (base != null) {
            List fileList = FileTools.getPathList(file);
            List baseList = FileTools.getPathList(base);
            relativePath = FileTools.matchPathLists(fileList, baseList);
        }
        if (relativePath == null) {
            return file.getAbsolutePath();
        }
        return relativePath;
    }

    public static String getPathRelativeTo(File file, File base, boolean ifAncestor) {
        if (base == null) {
            return file.getPath();
        }
        if (FileTools.isAncestor(base, file)) {
            try {
                return FileTools.getPathRelativeTo(file, base);
            }
            catch (IOException e) {
                return file.getPath();
            }
        }
        return file.getPath();
    }

    public static boolean hasLeadingSeparator(String path) {
        return path.startsWith("\\") || path.startsWith("/");
    }

    public static boolean hasTrailingSeparator(String path) {
        return path.endsWith("\\") || path.endsWith("/");
    }

    public static boolean isAncestor(File parent, File descendant) {
        if (parent == null) {
            return false;
        }
        File current = descendant;
        while (!parent.equals(current)) {
            if (current == null) {
                return false;
            }
            current = current.getParentFile();
        }
        return true;
    }

    public static boolean isExtensionMatch(File file, String extensions) {
        if (StringTools.isEmpty(extensions)) {
            return false;
        }
        String[] tempExtensions = extensions.toLowerCase().split(";");
        String tempName = file.getName().toLowerCase();
        int i = 0;
        while (i < tempExtensions.length) {
            if (tempName.endsWith(tempExtensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isLegalPath(String filename) {
        if (SystemTools.isWindows()) {
            String fileName = new File(filename).getName();
            if (filename.indexOf("<") != -1 || filename.indexOf(">") != -1 || filename.indexOf("?") != -1 || filename.indexOf("\"") != -1 || fileName.indexOf(":") != -1 || filename.indexOf("|") != -1 || filename.indexOf("*") != -1) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocked(File file) {
        Map<File, Lock> map = maps;
        synchronized (map) {
            Lock tempLock;
            block13: {
                if (maps.get(file) != null) {
                    return true;
                }
                File lockFile = FileTools.getLockFile(file);
                if (!lockFile.exists()) {
                    return false;
                }
                tempLock = null;
                try {
                    tempLock = FileTools.lock(file);
                    if (tempLock == null) break block13;
                    Log.log(Level.INFO, "found abandoned lock '" + tempLock.file.getAbsolutePath() + "', take over");
                    if (tempLock != null) {
                        tempLock.release();
                    }
                }
                catch (Exception e) {
                    if (tempLock != null) {
                        tempLock.release();
                    }
                    return true;
                    catch (Throwable throwable) {
                        if (tempLock != null) {
                            tempLock.release();
                        }
                        throw throwable;
                    }
                }
                return false;
            }
            if (tempLock != null) {
                tempLock.release();
            }
            return true;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean isReadOnly(File file) {
        boolean delete = !file.exists();
        RandomAccessFile r = null;
        try {
            r = new RandomAccessFile(file, "rw");
        }
        catch (IOException e) {
            StreamTools.close(r);
            if (delete && file.exists()) {
                file.delete();
            }
            return true;
            catch (Throwable throwable) {
                StreamTools.close(r);
                if (delete && file.exists()) {
                    file.delete();
                }
                throw throwable;
            }
        }
        StreamTools.close(r);
        if (delete && file.exists()) {
            file.delete();
        }
        return false;
    }

    public static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static String joinPath(String ... segment) {
        StringBuilder sb = new StringBuilder();
        boolean addSeparator = false;
        String[] stringArray = segment;
        int n = segment.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (addSeparator) {
                sb.append(File.separator);
            }
            sb.append(string);
            addSeparator = string.length() > 0 && !FileTools.hasTrailingSeparator(string);
            ++n2;
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock lock(File file) {
        Map<File, Lock> map = maps;
        synchronized (map) {
            block10: {
                if (maps.get(file) == null) break block10;
                Log.log(Level.FINEST, "lock acquisition failed on " + file);
                return null;
            }
            FileOutputStream os = null;
            FileChannel channel = null;
            File lockFile = FileTools.getLockFile(file);
            try {
                os = new FileOutputStream(lockFile);
                channel = os.getChannel();
                channel.tryLock();
                Lock lock = new Lock();
                lock.file = file;
                lock.lockFile = lockFile;
                lock.lockStream = os;
                maps.put(file, lock);
                Log.log(Level.FINEST, "lock acquired on " + file);
                return lock;
            }
            catch (Exception e) {
                StreamTools.close(os);
                if (channel != null) {
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (lockFile != null) {
                    lockFile.delete();
                }
                Log.log(Level.FINEST, "lock acquisition failed on " + file);
                return null;
            }
        }
    }

    private static String matchPathLists(List fileList, List baseList) {
        Iterator sourceIterator = baseList.iterator();
        Iterator targetIterator = fileList.iterator();
        boolean intersection = false;
        while (sourceIterator.hasNext() && targetIterator.hasNext()) {
            if (!sourceIterator.next().equals(targetIterator.next())) break;
            sourceIterator.remove();
            targetIterator.remove();
            intersection = true;
        }
        if (!intersection) {
            return null;
        }
        String relPath = "";
        int i = 0;
        while (i < baseList.size()) {
            relPath = String.valueOf(relPath) + ".." + File.separator;
            ++i;
        }
        Iterator i2 = fileList.iterator();
        while (i2.hasNext()) {
            relPath = String.valueOf(relPath) + i2.next();
            if (!i2.hasNext()) continue;
            relPath = String.valueOf(relPath) + File.separator;
        }
        return relPath;
    }

    public static void renameFile(File source, File destination) throws IOException {
        FileTools.renameFile(source, null, destination, null);
    }

    public static void renameFile(File source, String sourceEncoding, File destination, String destinationEncoding) throws IOException {
        boolean renameByCopy;
        if (source.getCanonicalFile().equals(destination.getCanonicalFile())) {
            return;
        }
        destination.delete();
        boolean bl = renameByCopy = sourceEncoding != null && destinationEncoding != null && !sourceEncoding.equals(destinationEncoding);
        if (!renameByCopy) {
            if (Log.isLoggable(Level.FINEST)) {
                Log.log(Level.FINEST, "rename '" + source.getAbsolutePath() + "' to '" + destination.getAbsolutePath());
            }
            if (source.renameTo(destination)) {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.log(Level.FINEST, "rename native success");
                }
                return;
            }
            if (Log.isLoggable(Level.FINEST)) {
                Log.log(Level.FINEST, "rename native failed");
            }
        }
        File tempDestination = new File(String.valueOf(destination.getAbsolutePath()) + ".--temporary--");
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "rename create temp file for '" + source.getAbsolutePath() + "' at '" + tempDestination.getAbsolutePath());
        }
        FileTools.copyFile(source, sourceEncoding, tempDestination, destinationEncoding);
        if (!tempDestination.renameTo(destination)) {
            if (Log.isLoggable(Level.FINE)) {
                Log.log(Level.FINE, "rename temp file failed");
            }
            tempDestination.delete();
            throw new IOException("rename temp file failed for '" + tempDestination.getAbsolutePath() + "'");
        }
        if (!source.delete()) {
            destination.delete();
            if (Log.isLoggable(Level.FINE)) {
                Log.log(Level.FINE, "rename delete source");
            }
            throw new IOException("rename delete source failed for '" + source.getAbsolutePath() + "'");
        }
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "rename harder success");
        }
    }

    public static File resolvePath(File parent, String path) {
        if (StringTools.isEmpty(path)) {
            return parent == null ? new File("") : parent;
        }
        if (parent == null) {
            return new File(path);
        }
        File file = new File(path);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(parent, path);
    }

    public static byte[] toBytes(File file) throws IOException {
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            byte[] byArray = StreamTools.toByteArray(is);
            return byArray;
        }
    }

    public static String toString(File file) throws IOException {
        return FileTools.toString(file, System.getProperty("file.encoding"));
    }

    public static String toString(File file, String encoding) throws IOException {
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            String string = StreamTools.toString(is, encoding);
            return string;
        }
    }

    public static String trimPath(String param) {
        if (param == null) {
            return null;
        }
        String tmp = param.trim();
        String drivePrefix = "";
        if (tmp.length() >= 2 && tmp.charAt(1) == ':') {
            drivePrefix = tmp.substring(0, 2);
            tmp = tmp.substring(2);
        }
        tmp = tmp.replaceAll("[\\*\"\\?\\<\\>\\|\\:\\n\\t\\r\\f]", "_");
        return String.valueOf(drivePrefix) + tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unlock(Lock lock) {
        Map<File, Lock> map = maps;
        synchronized (map) {
            maps.remove(lock.file);
            lock.valid = false;
            StreamTools.close(lock.lockStream);
            lock.lockFile.delete();
        }
    }

    public static void wait(File file, long timeout, long delay) throws IOException {
        long stop = System.currentTimeMillis() + timeout;
        try {
            while (true) {
                if (file.exists()) {
                    if (delay > 0L) {
                        long oldSize = -1L;
                        long newSize = file.length();
                        while (oldSize != newSize) {
                            oldSize = newSize;
                            Thread.sleep(delay);
                            newSize = file.length();
                        }
                    }
                    return;
                }
                if (System.currentTimeMillis() > stop) {
                    throw new IOException("timeout waiting for " + file.getPath());
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("interrupted waiting for " + file.getPath());
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String withoutTrailingSeparator(String path) {
        if (!StringTools.isEmpty(path)) ** GOTO lbl4
        return "";
lbl-1000:
        // 1 sources

        {
            path = path.substring(0, path.length() - 1);
lbl4:
            // 2 sources

            ** while (FileTools.hasTrailingSeparator((String)path))
        }
lbl5:
        // 1 sources

        return path;
    }

    public static String withTrailingSeparator(String path) {
        if (StringTools.isEmpty(path)) {
            return "";
        }
        if (FileTools.hasTrailingSeparator(path)) {
            return path;
        }
        return String.valueOf(path) + File.separator;
    }

    public static void write(File file, byte[] bytes) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            os.write(bytes);
        }
        finally {
            StreamTools.close(os);
        }
    }

    public static void write(File file, String text) throws IOException {
        FileTools.write(file, text, Charset.defaultCharset().name(), false);
    }

    public static void write(File file, String text, boolean append) throws IOException {
        FileTools.write(file, text, Charset.defaultCharset().name(), append);
    }

    public static void write(File file, String text, String encoding) throws IOException {
        FileTools.write(file, text, encoding, false);
    }

    public static void write(File file, String text, String encoding, boolean append) throws IOException {
        FileOutputStream os = null;
        OutputStreamWriter writer = null;
        try {
            os = new FileOutputStream(file, append);
            writer = new OutputStreamWriter((OutputStream)os, encoding);
            writer.write(text);
        }
        catch (Throwable throwable) {
            StreamTools.close(writer);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(writer);
        StreamTools.close(os);
    }

    private FileTools() {
    }

    public static class Lock {
        protected File file;
        protected File lockFile;
        protected FileOutputStream lockStream;
        protected boolean valid = true;

        public synchronized boolean isValid() {
            return this.valid;
        }

        public synchronized void release() {
            FileTools.unlock(this);
        }
    }
}

