/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.IArgs;
import java.io.File;

public class FilenameResolver
implements IStringEvaluator {
    private final File file;
    private final String extensionPrefix;

    public FilenameResolver(File file) {
        this.file = file;
        this.extensionPrefix = null;
    }

    public FilenameResolver(File file, String extensionPrefix) {
        this.file = file;
        this.extensionPrefix = extensionPrefix;
    }

    @Override
    public Object evaluate(String expression, IArgs args) throws EvaluationException {
        if ("path".equals(expression)) {
            return FileTools.getPathName(this.file);
        }
        if ("basename".equals(expression)) {
            return FileTools.getBaseName(this.file.getName(), this.extensionPrefix, "");
        }
        if ("extension".equals(expression)) {
            return FileTools.getExtension(this.file.getName(), this.extensionPrefix, "");
        }
        if ("name".equals(expression)) {
            return FileTools.getFileName(this.file);
        }
        throw new EvaluationException("can't evaluate '" + expression + "'");
    }
}

