/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.IPathFilter;
import de.intarsys.tools.file.WildcardMatch;
import java.util.ArrayList;
import java.util.List;

public class PathFilter
implements IPathFilter {
    private List<String> includes = new ArrayList<String>();
    private List<String> excludes = new ArrayList<String>();
    private static final WildcardMatch matcher = new WildcardMatch();

    @Override
    public boolean accept(String path) {
        return this.includes(path) && !this.excludes(path);
    }

    public void addExclude(String name) {
        this.excludes.add(name);
    }

    public void addInclude(String name) {
        this.includes.add(name);
    }

    protected boolean excludes(String path) {
        if (this.excludes.isEmpty()) {
            return false;
        }
        for (String exclude : this.getExcludes()) {
            if (!this.match(exclude, path)) continue;
            return true;
        }
        return false;
    }

    public List<String> getExcludes() {
        return new ArrayList<String>(this.excludes);
    }

    public List<String> getIncludes() {
        return new ArrayList<String>(this.includes);
    }

    protected boolean includes(String path) {
        if (this.includes.isEmpty()) {
            return true;
        }
        for (String include : this.getIncludes()) {
            if (!this.match(include, path)) continue;
            return true;
        }
        return false;
    }

    protected boolean match(String pattern, String path) {
        return matcher.match(pattern, path);
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }
}

