/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.StringTools;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class ArgTools {
    private static int nesting = 0;
    public static final IFunctor<String> toString = new IFunctor<String>(){

        @Override
        public String perform(IFunctorCall call) throws FunctorInvocationException {
            Args args = (Args)call.getReceiver();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                if (binding.getName() != null) {
                    sb.append(binding.getName());
                } else {
                    sb.append(i);
                }
                sb.append(" = ");
                sb.append(binding.getValue());
                sb.append("\n");
                ++i;
            }
            return sb.toString();
        }
    };
    private static Set visited;

    protected static Object basicGet(IArgs args, int index, String name) {
        Object argsValue = name != null ? args.get(name) : args.get(index);
        return argsValue;
    }

    protected static Object basicGet(IArgs args, String name) {
        try {
            int index = Integer.parseInt(name.trim());
            return args.get(index);
        }
        catch (NumberFormatException e) {
            return args.get(name);
        }
    }

    protected static void basicPut(IArgs args, int index, String name, Object otherValue) {
        if (name == null) {
            args.put(index, otherValue);
        } else {
            args.put(name, otherValue);
        }
    }

    protected static <T> T convert(Object value, Class<T> clazz) throws ConversionException {
        return ConverterRegistry.get().convert(value, clazz);
    }

    protected static <T> T convert(Object value, Class<T> clazz, Object defaultValue) {
        try {
            T result = ArgTools.convert(value, clazz);
            if (result != null) {
                return result;
            }
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        return (T)defaultValue;
    }

    public static IArgs createArgs() {
        return Args.create();
    }

    public static IArgs expandDeep(IArgs args, IStringEvaluator evaluator) {
        int index = -1;
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            ++index;
            if (!binding.isDefined()) continue;
            String name = binding.getName();
            Object value = binding.getValue();
            if (value instanceof IArgs) {
                ArgTools.expandDeep((IArgs)value, evaluator);
                continue;
            }
            if (!(value instanceof String)) continue;
            try {
                ArgTools.basicPut(args, index, name, evaluator.evaluate((String)value, Args.create()));
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return args;
    }

    public static IArgs expandDeep(IArgs args, String name, IStringEvaluator evaluator) {
        Object value = ArgTools.getPath(args, name);
        if (value instanceof IArgs) {
            ArgTools.expandDeep((IArgs)value, evaluator);
        } else if (value instanceof String) {
            try {
                Object newValue = evaluator.evaluate((String)value, Args.create());
                ArgTools.putPath(args, name, newValue);
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return args;
    }

    public static IArgs getArgs(IArgs args, String name, IArgs defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        return ArgTools.toArgs(optionValue);
    }

    public static boolean getBool(IArgs args, String name, boolean defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Boolean) {
            return (Boolean)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            return Converter.asBoolean(optionString, defaultValue);
        }
        return ArgTools.convert(optionValue, Boolean.class, defaultValue);
    }

    public static boolean getBoolean(IArgs args, String name, boolean defaultValue) {
        return ArgTools.getBool(args, name, defaultValue);
    }

    public static byte getByte(IArgs args, String name, byte defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            try {
                return Byte.parseByte(((String)value).trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(value, Byte.class, defaultValue);
    }

    public static byte[] getByteArray(IArgs args, String name, byte[] defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return Base64.decode((String)value);
        }
        if (value instanceof ILocator) {
            try {
                return LocatorTools.getBytes((ILocator)value);
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        if (value instanceof ILocatorSupport) {
            try {
                return LocatorTools.getBytes(((ILocatorSupport)value).getLocator());
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(value, byte[].class, defaultValue);
    }

    public static char getChar(IArgs args, String name, char defaultValue) {
        String valueString;
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String && (valueString = (String)value).length() > 0) {
            return valueString.charAt(0);
        }
        return ArgTools.convert(value, Character.class, Character.valueOf(defaultValue)).charValue();
    }

    public static char[] getCharArray(IArgs args, String name, char[] defaultValue) throws IllegalArgumentException {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof char[]) {
            return (char[])optionValue;
        }
        if (optionValue instanceof String) {
            return ((String)optionValue).toCharArray();
        }
        try {
            return ArgTools.convert(optionValue, char[].class);
        }
        catch (ConversionException e) {
            return defaultValue;
        }
    }

    public static Class getClass(IArgs args, String name, Class defaultValue, ClassLoader classLoader) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Class) {
            return (Class)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            try {
                return ClassTools.createClass(optionString, Object.class, classLoader);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(optionValue, Class.class, defaultValue);
    }

    public static Color getColor(IArgs args, String name, Color defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Color) {
            return (Color)optionValue;
        }
        if (optionValue instanceof String) {
            try {
                return Color.decode(((String)optionValue).trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(optionValue, Color.class, defaultValue);
    }

    public static Date getDate(IArgs args, String name, Date defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Date) {
            return (Date)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            try {
                return DateFormat.getInstance().parse(optionString.trim());
            }
            catch (ParseException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(optionValue, Date.class, defaultValue);
    }

    public static IDigest getDigest(IArgs args, String name) throws IOException {
        if (args == null) {
            return null;
        }
        Object optionValue = ArgTools.getPath(args, name);
        return DigestTools.createDigest(optionValue);
    }

    public static <T extends EnumItem> T getEnumItem(IArgs args, EnumMeta<T> meta, String name) {
        return ArgTools.getEnumItem(args, meta, name, meta.getDefault());
    }

    public static <T extends EnumItem> T getEnumItem(IArgs args, EnumMeta<T> meta, String name, String defaultValue) {
        if (args == null) {
            return meta.getItemOrDefault(defaultValue);
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return meta.getItemOrDefault(defaultValue);
        }
        if (optionValue instanceof EnumItem) {
            return (T)((EnumItem)optionValue);
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            return meta.getItemOrDefault(optionString.trim());
        }
        return (T)((EnumItem)ArgTools.convert(optionValue, meta.getEnumClazz(), meta.getItemOrDefault(defaultValue)));
    }

    public static <T extends EnumItem> T getEnumItem(IArgs args, EnumMeta<T> meta, String name, T defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof EnumItem) {
            return (T)((EnumItem)optionValue);
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            return meta.getItemOrDefault(optionString.trim());
        }
        return (T)((EnumItem)ArgTools.convert(optionValue, meta.getEnumClazz(), defaultValue));
    }

    public static File getFile(IArgs args, String name, File defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof String) {
            return new File(((String)value).trim());
        }
        if (value instanceof FileLocator) {
            return ((FileLocator)value).getFile();
        }
        if (value instanceof ILocator) {
            return new File(((ILocator)value).getFullName());
        }
        return ArgTools.convert(value, File.class, defaultValue);
    }

    public static float getFloat(IArgs args, String name, float defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.indexOf("%") != -1) {
                try {
                    Number result = NumberFormat.getPercentInstance().parse(stringValue.trim());
                    return result.floatValue();
                }
                catch (ParseException e) {
                    return defaultValue;
                }
            }
            try {
                return Float.parseFloat(stringValue.trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(value, Float.class, Float.valueOf(defaultValue)).floatValue();
    }

    public static int getInt(IArgs args, String name, int defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt(((String)value).trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(value, Integer.class, defaultValue);
    }

    public static List getList(IArgs args, String name, List defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof List) {
            return (List)optionValue;
        }
        if (optionValue instanceof String) {
            return Converter.asList((String)optionValue);
        }
        if (optionValue instanceof IArgs) {
            return ArgTools.toList((IArgs)optionValue);
        }
        if (optionValue instanceof Object[]) {
            return Arrays.asList((Object[])optionValue);
        }
        return ArgTools.convert(optionValue, List.class, defaultValue);
    }

    public static ILocator getLocator(IArgs args, String name, ILocator defaultValue, ILocatorFactory factory) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        return LocatorTools.createLocator(optionValue, factory, defaultValue);
    }

    public static List<ILocator> getLocators(IArgs args, String name, ILocatorFactory factory) {
        if (args == null) {
            return null;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return null;
        }
        if (optionValue instanceof ILocator[]) {
            return Arrays.asList((ILocator[])optionValue);
        }
        ArrayList<ILocator> locators = new ArrayList<ILocator>();
        if (optionValue instanceof Collection) {
            for (Object candidate : (Collection)optionValue) {
                ILocator locator = LocatorTools.createLocator(candidate, factory, null);
                if (locator == null) continue;
                locators.add(locator);
            }
        } else if (optionValue instanceof Object[]) {
            Object[] values = (Object[])optionValue;
            int i = 0;
            while (i < values.length) {
                ILocator locator = LocatorTools.createLocator(values[i], factory, null);
                if (locator != null) {
                    locators.add(locator);
                }
                ++i;
            }
        } else if (optionValue instanceof IArgs) {
            ILocator locator;
            Iterator<IArgs.IBinding> values = ((IArgs)optionValue).bindings();
            while (values.hasNext()) {
                IArgs.IBinding binding = values.next();
                if (binding.getName() != null) break;
                ILocator locator2 = LocatorTools.createLocator(binding.getValue(), factory, null);
                if (locator2 == null) continue;
                locators.add(locator2);
            }
            if (locators.isEmpty() && (locator = LocatorTools.createLocator(optionValue, factory, null)) != null) {
                locators.add(locator);
            }
        } else {
            ILocator locator = LocatorTools.createLocator(optionValue, factory, null);
            if (locator != null) {
                locators.add(locator);
            }
        }
        return locators;
    }

    public static Level getLogLevel(IArgs args, String name, Level defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Level) {
            return (Level)optionValue;
        }
        if (optionValue instanceof String) {
            try {
                return Level.parse(((String)optionValue).trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(optionValue, Level.class, defaultValue);
    }

    public static long getLong(IArgs args, String name, long defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong(((String)value).trim());
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(value, Long.class, defaultValue);
    }

    public static Map getMap(IArgs args, String name, Map defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Map) {
            return (Map)optionValue;
        }
        if (optionValue instanceof String) {
            return Converter.asMap((String)optionValue);
        }
        if (optionValue instanceof IArgs) {
            return ArgTools.toMap((IArgs)optionValue);
        }
        return ArgTools.convert(optionValue, Map.class, defaultValue);
    }

    public static Object getObject(IArgs args, String name, Object defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        return optionValue;
    }

    public static Object getPath(IArgs args, String path) {
        if (StringTools.isEmpty(path) || ".".equals(path)) {
            return args;
        }
        String[] segments = path.split("\\.");
        int position = 0;
        while (position < segments.length - 1) {
            Object tempValue = ArgTools.basicGet(args, segments[position]);
            if ((args = ArgTools.toArgs(tempValue)) == null) {
                return null;
            }
            ++position;
        }
        return ArgTools.basicGet(args, segments[position]);
    }

    public static Point2D getPoint(IArgs args, String name, Point2D defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof Point2D) {
            return (Point2D)optionValue;
        }
        if (optionValue instanceof String) {
            String optionString = (String)optionValue;
            String[] coords = optionString.trim().split("[x*@]");
            if (coords == null || coords.length != 2) {
                return defaultValue;
            }
            try {
                float x = Float.parseFloat(coords[0]);
                float y = Float.parseFloat(coords[1]);
                return new Point2D.Float(x, y);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return ArgTools.convert(optionValue, Point2D.class, defaultValue);
    }

    public static String getString(IArgs args, String name, String defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object optionValue = ArgTools.getPath(args, name);
        if (optionValue == null) {
            return defaultValue;
        }
        if (optionValue instanceof String) {
            return (String)optionValue;
        }
        if (optionValue instanceof char[]) {
            return new String((char[])optionValue);
        }
        return ArgTools.convert(optionValue, String.class, String.valueOf(optionValue));
    }

    public static <T> T getValue(IArgs args, String name, Class<T> clazz, Object defaultValue) {
        if (args == null) {
            return (T)defaultValue;
        }
        Object value = ArgTools.getPath(args, name);
        return ArgTools.convert(value, clazz, defaultValue);
    }

    public static boolean isDefined(IArgs args, String path) {
        int index;
        String name;
        if (StringTools.isEmpty(path) || ".".equals(path)) {
            return true;
        }
        String[] segments = path.split("\\.");
        int position = 0;
        while (position < segments.length - 1) {
            Object tempValue;
            block9: {
                name = segments[position];
                index = Integer.parseInt(name.trim());
                if (args.isDefined(index)) break block9;
                return false;
            }
            try {
                tempValue = args.get(index);
            }
            catch (NumberFormatException e) {
                if (!args.isDefined(name)) {
                    return false;
                }
                tempValue = args.get(name);
            }
            args = ArgTools.toArgs(tempValue);
            if (args == null) {
                return false;
            }
            ++position;
        }
        name = segments[position];
        try {
            index = Integer.parseInt(name.trim());
            return args.isDefined(index);
        }
        catch (NumberFormatException e) {
            return args.isDefined(name);
        }
    }

    public static String prefix(String prefix, String name) {
        if (prefix == null || prefix.length() == 0) {
            return name;
        }
        if (name == null) {
            return null;
        }
        return String.valueOf(prefix) + Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static IArgs putAll(IArgs args, IArgs other) {
        Iterator<IArgs.IBinding> it = other.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            if (binding.getName() == null) continue;
            args.put(binding.getName(), binding.getValue());
        }
        return args;
    }

    public static IArgs putAll(IArgs args, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            ArgTools.putPath(args, String.valueOf(entry.getKey()), entry.getValue());
        }
        return args;
    }

    public static IArgs putAllDeep(IArgs args, IArgs other) {
        int index = -1;
        Iterator<IArgs.IBinding> it = other.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            ++index;
            if (!binding.isDefined()) continue;
            String name = binding.getName();
            Object otherValue = binding.getValue();
            if ("+".equals(name)) {
                args.add(otherValue);
                continue;
            }
            Object argsValue = ArgTools.basicGet(args, index, name);
            if (argsValue instanceof IArgs) {
                if (otherValue instanceof IArgs) {
                    ArgTools.putAllDeep((IArgs)argsValue, (IArgs)otherValue);
                    continue;
                }
                ArgTools.basicPut(args, index, name, otherValue);
                continue;
            }
            ArgTools.basicPut(args, index, name, otherValue);
        }
        return args;
    }

    public static IArgs putAllDeep(IArgs args, List list) {
        int i = 0;
        for (Object listValue : list) {
            Object argsValue = args.get(i);
            if (argsValue instanceof IArgs) {
                if (listValue instanceof Map) {
                    ArgTools.putAllDeep((IArgs)argsValue, (Map)listValue);
                } else if (listValue instanceof List) {
                    ArgTools.putAllDeep((IArgs)argsValue, (List)listValue);
                } else {
                    args.put(i, listValue);
                }
            } else if (listValue instanceof Map) {
                args.put(i, (Object)ArgTools.toArgs(listValue));
            } else if (listValue instanceof List) {
                args.put(i, (Object)ArgTools.toArgs(listValue));
            } else {
                args.put(i, listValue);
            }
            ++i;
        }
        return args;
    }

    public static IArgs putAllDeep(IArgs args, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String name = String.valueOf(entry.getKey());
            Object mapValue = entry.getValue();
            Object argsValue = ArgTools.getPath(args, name);
            if (argsValue instanceof IArgs) {
                if (mapValue instanceof Map) {
                    ArgTools.putAllDeep((IArgs)argsValue, (Map)mapValue);
                    continue;
                }
                if (mapValue instanceof List) {
                    ArgTools.putAllDeep((IArgs)argsValue, (List)mapValue);
                    continue;
                }
                ArgTools.putPath(args, name, mapValue);
                continue;
            }
            if (mapValue instanceof Map) {
                ArgTools.putPath(args, name, ArgTools.toArgs(mapValue));
                continue;
            }
            if (mapValue instanceof List) {
                ArgTools.putPath(args, name, ArgTools.toArgs(mapValue));
                continue;
            }
            ArgTools.putPath(args, name, mapValue);
        }
        return args;
    }

    public static IArgs putAllIfAbsent(IArgs args, IArgs other) {
        Iterator<IArgs.IBinding> it = other.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            if (binding.getName() == null || args.isDefined(binding.getName())) continue;
            args.put(binding.getName(), binding.getValue());
        }
        return args;
    }

    public static IArgs putAllIfAbsent(IArgs args, Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (args.isDefined(key)) continue;
            ArgTools.putPath(args, key, entry.getValue());
        }
        return args;
    }

    public static IArgs putAllIfAbsentDeep(IArgs args, IArgs other) {
        Iterator<IArgs.IBinding> it = other.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            if (binding.getName() == null) continue;
            Object argsValue = args.get(binding.getName());
            Object otherValue = binding.getValue();
            if (argsValue instanceof IArgs && otherValue instanceof IArgs) {
                ArgTools.putAllIfAbsentDeep((IArgs)argsValue, (IArgs)otherValue);
                continue;
            }
            if (args.isDefined(binding.getName())) continue;
            args.put(binding.getName(), binding.getValue());
        }
        return args;
    }

    public static void putDefinition(IArgs args, String definition) {
        if (StringTools.isEmpty(definition)) {
            return;
        }
        StringReader r = new StringReader(definition);
        try {
            Map.Entry<String, String> entry;
            while ((entry = ReaderTools.readEntry(r, ';')) != null) {
                if (entry.getKey() == null) continue;
                ArgTools.putPath(args, entry.getKey(), entry.getValue());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static IArgs putMapped(IArgs args, IArgs other, String[] argsNames, String[] otherNames) {
        int i = 0;
        while (i < otherNames.length) {
            ArgTools.putPath(args, argsNames[i], ArgTools.getPath(other, otherNames[i]));
            ++i;
        }
        return args;
    }

    public static IArgs putPath(IArgs args, String path, Object value) {
        int index;
        String name;
        String[] segments = path.split("\\.");
        int position = 0;
        while (position < segments.length - 1) {
            Object tempValue;
            block8: {
                name = segments[position];
                try {
                    index = Integer.parseInt(name.trim());
                    tempValue = args.get(index);
                    if (!(tempValue instanceof IArgs)) {
                        if ((tempValue = ArgTools.toArgs(tempValue)) == null) {
                            tempValue = Args.create();
                        }
                        args.put(index, tempValue);
                    }
                }
                catch (NumberFormatException e) {
                    tempValue = args.get(name);
                    if (tempValue instanceof IArgs) break block8;
                    if ((tempValue = ArgTools.toArgs(tempValue)) == null) {
                        tempValue = Args.create();
                    }
                    args.put(name, tempValue);
                }
            }
            args = (IArgs)tempValue;
            ++position;
        }
        name = segments[position];
        try {
            index = Integer.parseInt(name.trim());
            args.put(index, value);
        }
        catch (NumberFormatException e) {
            args.put(name, value);
        }
        return args;
    }

    public static IArgs toArgs(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof IArgs) {
            return (IArgs)((Object)value);
        }
        if (value instanceof String) {
            value = Converter.asMap((String)((Object)value));
        }
        if (value instanceof Map) {
            Args args = Args.create();
            ArgTools.putAllDeep((IArgs)args, value);
            return args;
        }
        if (value instanceof List) {
            return new Args((List)((Object)value));
        }
        return ArgTools.convert(value, IArgs.class, Args.create());
    }

    public static List toList(IArgs args) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (args != null) {
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                if (!binding.isDefined()) continue;
                result.add(binding.getValue());
            }
        }
        return result;
    }

    public static Map toMap(IArgs args) {
        int i = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (args != null) {
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                if (!binding.isDefined()) continue;
                Object value = binding.getValue();
                String key = binding.getName() != null ? binding.getName() : "" + i;
                result.put(key, value);
                ++i;
            }
        }
        return result;
    }

    public static Map toMapDeep(IArgs args) {
        int i = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (args != null) {
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                IArgs.IBinding binding = it.next();
                if (!binding.isDefined()) continue;
                Object value = binding.getValue();
                if (value instanceof IArgs) {
                    value = ArgTools.toMapDeep((IArgs)value);
                }
                String key = binding.getName() != null ? binding.getName() : "" + i;
                result.put(key, value);
                ++i;
            }
        }
        return result;
    }

    public static Map<String, Object> toMapDeepFlat(IArgs args) {
        return ArgTools.toMapDeepFlat(args, null, new HashMap<String, Object>());
    }

    public static Map<String, Object> toMapDeepFlat(IArgs args, String prefix, Map<String, Object> map) {
        int i = 0;
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            Object value;
            IArgs.IBinding binding = it.next();
            if (!binding.isDefined()) continue;
            String key = binding.getName() != null ? binding.getName() : "" + i;
            if (!StringTools.isEmpty(prefix)) {
                key = String.valueOf(prefix) + "." + key;
            }
            if ((value = binding.getValue()) instanceof IArgs) {
                ArgTools.toMapDeepFlat((IArgs)value, key, map);
            } else {
                map.put(key, value);
            }
            ++i;
        }
        return map;
    }

    public static synchronized String toString(IArgs args, String prefix) {
        if (visited == null) {
            visited = new HashSet();
            nesting = 0;
        }
        if (visited.contains(args)) {
            return "...recursive...";
        }
        if (nesting == 5) {
            return "...nested to deep...";
        }
        visited.add(args);
        ++nesting;
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            Iterator<IArgs.IBinding> it = args.bindings();
            while (it.hasNext()) {
                Object value;
                IArgs.IBinding binding = it.next();
                if (!binding.isDefined()) {
                    ArgTools.toStringUndefined(prefix, sb, binding.getName());
                } else if (binding.getName() != null) {
                    value = binding.getValue();
                    if (value instanceof IArgs) {
                        ArgTools.toStringArgs(prefix, sb, binding.getName(), (IArgs)value);
                    } else {
                        ArgTools.toStringPlain(prefix, sb, binding.getName(), value);
                    }
                } else {
                    value = binding.getValue();
                    if (value instanceof IArgs) {
                        ArgTools.toStringArgs(prefix, sb, "" + i, (IArgs)value);
                    } else {
                        ArgTools.toStringPlain(prefix, sb, "" + i, value);
                    }
                }
                ++i;
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (--nesting == 0) {
                visited = null;
            }
        }
    }

    protected static void toStringArgs(String prefix, StringBuilder sb, String name, IArgs value) {
        int i = 1;
        while (i < nesting) {
            sb.append("   ");
            ++i;
        }
        sb.append(name);
        sb.append(" = ");
        sb.append("{");
        sb.append("\n");
        sb.append(ArgTools.toString(value, prefix));
        sb.append("\n");
        i = 1;
        while (i < nesting) {
            sb.append("   ");
            ++i;
        }
        sb.append("}");
        sb.append("\n");
    }

    protected static void toStringPlain(String prefix, StringBuilder sb, String name, Object value) {
        int i = 1;
        while (i < nesting) {
            sb.append("   ");
            ++i;
        }
        sb.append(name);
        sb.append(" = ");
        sb.append(StringTools.getLeading(StringTools.safeString(value), 10240));
        sb.append("\n");
    }

    protected static void toStringUndefined(String prefix, StringBuilder sb, String name) {
        int i = 1;
        while (i < nesting) {
            sb.append("   ");
            ++i;
        }
        sb.append(name);
        sb.append(" = UNDEFINED");
        sb.append("\n");
    }

    public static void undefinePath(IArgs args, String path) {
        String name;
        if (StringTools.isEmpty(path)) {
            return;
        }
        int lastIndex = path.lastIndexOf(46);
        if (lastIndex > 0) {
            name = path.substring(lastIndex + 1);
            if ((args = ArgTools.toArgs(ArgTools.getPath(args, path.substring(0, lastIndex)))) == null) {
                return;
            }
        } else {
            name = path;
        }
        try {
            int index = Integer.parseInt(name.trim());
            args.undefine(index);
        }
        catch (NumberFormatException e) {
            args.undefine(name);
        }
    }

    public static void visitNamedBindings(String prefix, IArgs args, IBindingProcessor processor) {
        processor.visitArgs(prefix, args);
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            String name = binding.getName();
            if (name == null) continue;
            Object value = binding.getValue();
            if (value instanceof IArgs) {
                ArgTools.visitNamedBindings(StringTools.pathAppend(prefix, ".", name), (IArgs)value, processor);
                continue;
            }
            processor.visitBinding(prefix, args, binding);
        }
    }

    public static interface IBindingProcessor {
        public Object visitArgs(String var1, IArgs var2);

        public Object visitBinding(String var1, IArgs var2, IArgs.IBinding var3);
    }
}

