/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.collection.ArrayIterator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Args
implements IArgs {
    private static final Binding[] EMPTY = new Binding[0];
    private static final Object UNDEFINED = new Object();
    private Binding[] entries = EMPTY;
    private int ptr = 0;

    public static Args create() {
        return new Args();
    }

    public static Args createIndexed(Object ... values) {
        return new Args(values);
    }

    public static Args createNamed(Object ... keyValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < keyValue.length) {
            String key = String.valueOf(keyValue[i++]);
            Object value = null;
            if (i < keyValue.length) {
                value = keyValue[i++];
            }
            map.put(key, value);
        }
        return new Args(map);
    }

    public Args() {
    }

    public Args(Args pArgs) {
        if (pArgs == null) {
            return;
        }
        this.ptr = pArgs.ptr;
        if (this.ptr > 0) {
            this.entries = new Binding[this.ptr];
            int i = 0;
            while (i < this.ptr) {
                Binding tempEntry = pArgs.entries[i];
                Object value = tempEntry.value;
                this.entries[i] = value instanceof IArgs ? new Binding(tempEntry.name, ((IArgs)value).copy()) : new Binding(tempEntry.name, value);
                ++i;
            }
        }
    }

    public Args(List<Object> values) {
        this.ptr = values.size();
        this.entries = new Binding[this.ptr];
        int i = 0;
        while (i < this.ptr) {
            this.entries[i] = new Binding(null, values.get(i));
            ++i;
        }
    }

    public Args(Map<String, Object> values) {
        this.ptr = values.size();
        this.entries = new Binding[this.ptr];
        int i = 0;
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            this.entries[i++] = new Binding(name, value);
        }
    }

    public Args(Object ... values) {
        if (values != null) {
            this.ptr = values.length;
            this.entries = new Binding[this.ptr];
            int i = 0;
            while (i < this.ptr) {
                this.entries[i] = new Binding(null, values[i]);
                ++i;
            }
        }
    }

    @Override
    public IArgs.IBinding add(Object object) {
        this.ensureCapacity(this.ptr);
        Binding tempBinding = new Binding(null, object);
        this.entries[this.ptr++] = tempBinding;
        return tempBinding;
    }

    @Override
    public Iterator<IArgs.IBinding> bindings() {
        return new ArrayIterator<IArgs.IBinding>(this.entries, this.ptr);
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.ptr) {
            this.entries[i] = null;
            ++i;
        }
        this.ptr = 0;
    }

    @Override
    public IArgs copy() {
        return new Args(this);
    }

    @Override
    public IArgs.IBinding declare(String name) {
        Binding tempBinding;
        int i = 0;
        while (i < this.ptr) {
            tempBinding = this.entries[i];
            if (name.equals(tempBinding.name)) {
                return tempBinding;
            }
            ++i;
        }
        i = 0;
        while (i < this.ptr) {
            tempBinding = this.entries[i];
            if (tempBinding.name == null) {
                tempBinding.name = name;
                return tempBinding;
            }
            ++i;
        }
        this.ensureCapacity(this.ptr);
        tempBinding = new Binding(name);
        this.entries[this.ptr++] = tempBinding;
        return tempBinding;
    }

    protected void ensureCapacity(int min) {
        if (min >= this.entries.length) {
            Binding[] newEntries = new Binding[min + 4];
            System.arraycopy(this.entries, 0, newEntries, 0, this.entries.length);
            this.entries = newEntries;
        }
    }

    @Override
    public Object get(int index) {
        if (index < 0 || index >= this.ptr) {
            return null;
        }
        if (this.entries[index].isDefined()) {
            return this.entries[index].value;
        }
        return null;
    }

    @Override
    public Object get(int index, Object defaultValue) {
        if (index < 0 || index >= this.ptr) {
            return defaultValue;
        }
        if (this.entries[index].isDefined()) {
            return this.entries[index].value;
        }
        return defaultValue;
    }

    @Override
    public Object get(String name) {
        int i = 0;
        while (i < this.ptr) {
            Binding entry = this.entries[i];
            if (name.equals(entry.name) && entry.isDefined()) {
                return entry.value;
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object get(String name, Object defaultValue) {
        int i = 0;
        while (i < this.ptr) {
            Binding entry = this.entries[i];
            if (name.equals(entry.name) && entry.isDefined()) {
                return entry.value;
            }
            ++i;
        }
        return defaultValue;
    }

    @Override
    public boolean isDefined(int index) {
        if (index < 0 || index >= this.ptr) {
            return false;
        }
        return this.entries[index].isDefined();
    }

    @Override
    public boolean isDefined(String name) {
        int i = 0;
        while (i < this.ptr) {
            Binding entry = this.entries[i];
            if (name.equals(entry.name)) {
                return entry.isDefined();
            }
            ++i;
        }
        return false;
    }

    public boolean isIndexed() {
        return true;
    }

    public boolean isNamed() {
        int i = 0;
        while (i < this.ptr) {
            Binding entry = this.entries[i];
            if (entry.name != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Set<String> names() {
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        while (i < this.ptr) {
            Binding entry = this.entries[i];
            if (entry.name != null) {
                result.add(entry.name);
            }
            ++i;
        }
        return result;
    }

    @Override
    public IArgs.IBinding put(int index, Object value) {
        Binding tempBinding;
        if (index >= this.ptr) {
            this.ensureCapacity(index);
            int i = this.ptr;
            while (i < index) {
                this.entries[i] = new Binding(null);
                ++i;
            }
            this.entries[index] = tempBinding = new Binding(null, value);
            this.ptr = index + 1;
        } else {
            tempBinding = this.entries[index];
            this.entries[index].setValue(value);
        }
        return tempBinding;
    }

    @Override
    public IArgs.IBinding put(String name, Object value) {
        int i = 0;
        while (i < this.ptr) {
            Binding entry = this.entries[i];
            if (name.equals(entry.name)) {
                Binding tempBinding = entry;
                entry.setValue(value);
                return tempBinding;
            }
            ++i;
        }
        this.ensureCapacity(this.ptr);
        Binding tempBinding = new Binding(name, value);
        this.entries[this.ptr++] = tempBinding;
        return tempBinding;
    }

    @Override
    public int size() {
        return this.ptr;
    }

    public String toString() {
        return ArgTools.toString(this, "");
    }

    @Override
    public void undefine(int index) {
        if (index < this.ptr) {
            this.entries[index].setValue(UNDEFINED);
        }
    }

    @Override
    public void undefine(String name) {
        int i = 0;
        while (i < this.ptr) {
            Binding entry = this.entries[i];
            if (name.equals(entry.name)) {
                Binding tempBinding = entry;
                entry.setValue(UNDEFINED);
            }
            ++i;
        }
    }

    static class Binding
    implements IArgs.IBinding {
        protected String name;
        protected Object value;

        protected Binding(String name) {
            this.name = name;
            this.value = UNDEFINED;
        }

        protected Binding(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return this.value == UNDEFINED ? null : this.value;
        }

        @Override
        public boolean isDefined() {
            return this.value != UNDEFINED;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public void setValue(Object pValue) {
            this.value = pValue;
        }

        public String toString() {
            return this.name + ":" + this.value;
        }
    }
}

