/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgumentDeclaration;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;
import de.intarsys.tools.functor.IDeclarationSupport;
import java.util.Iterator;

public class ArgumentDeclarator {
    private boolean lazy = true;
    private boolean strict = false;
    private static final Object UNDEFINED = new Object();

    public ArgumentDeclarator() {
    }

    public ArgumentDeclarator(boolean strict, boolean lazy) {
        this.strict = strict;
        this.lazy = lazy;
    }

    protected void apply(ArgumentDeclaration declaration, int index, IArgs args, IArgs targetArgs, IArgs scope) throws DeclarationException {
        String name = declaration.getName();
        Class<IArgs> type = declaration.getType();
        IDeclarationBlock declarationBlock = declaration.getDeclarationBlock();
        Object value = UNDEFINED;
        IArgs.IBinding targetBinding = null;
        if (".".equals(name)) {
            type = IArgs.class;
        } else {
            IArgs.IBinding binding;
            targetBinding = binding = args.declare(name);
            targetBinding = targetArgs != args ? targetArgs.declare(name) : binding;
            if (binding.isDefined()) {
                value = binding.getValue();
            }
        }
        if (value == UNDEFINED) {
            if (declaration.isDefaultDefined()) {
                try {
                    value = declaration.getDefaultValue(scope);
                }
                catch (FunctorInvocationException e) {
                    throw new DeclarationException(e);
                }
            } else if (declarationBlock != null && declarationBlock.size() > 0) {
                value = Args.create();
            }
        }
        if (value != UNDEFINED) {
            if (value instanceof IArgs && declarationBlock != null && declarationBlock.size() > 0) {
                new ArgumentDeclarator(this.strict, this.lazy).apply(declarationBlock, (IArgs)value);
            }
            try {
                if (type == IArgs.class) {
                    value = ArgTools.toArgs(value);
                } else if (type != Object.class) {
                    value = ConverterRegistry.get().convert(value, type);
                }
            }
            catch (ConversionException e) {
                throw new DeclarationException("Unable to convert value for argument '" + name + "' to type '" + type + "'", e);
            }
            if (targetBinding == null) {
                if (value instanceof IArgs) {
                    ArgTools.putAll(targetArgs, (IArgs)value);
                }
            } else {
                targetBinding.setValue(value);
            }
        }
    }

    protected void apply(IDeclaration declaration, int index, IArgs args, IArgs targetArgs, IArgs scope) throws DeclarationException {
        if (declaration instanceof ArgumentDeclaration) {
            ArgumentDeclaration argumentDeclaration = (ArgumentDeclaration)declaration;
            this.apply(argumentDeclaration, index, args, targetArgs, scope);
        } else if (declaration instanceof IDeclarationBlock) {
            this.apply((IDeclarationBlock)declaration, args, targetArgs, scope);
        } else if (declaration instanceof IDeclarationSupport) {
            this.apply(((IDeclarationSupport)((Object)declaration)).getDeclarationBlock(), args, targetArgs, scope);
        }
    }

    public IArgs apply(IDeclarationBlock declarationBlock, IArgs args) throws DeclarationException {
        IArgs targetArgs = args;
        if (this.strict) {
            targetArgs = new Args();
        }
        this.apply(declarationBlock, args, targetArgs, args);
        if (this.strict) {
            Iterator<IArgs.IBinding> bindings = targetArgs.bindings();
            if (!this.lazy || this.lazy && bindings.hasNext()) {
                args.clear();
                while (bindings.hasNext()) {
                    IArgs.IBinding binding = bindings.next();
                    if (binding.getName() == null) continue;
                    args.put(binding.getName(), binding.getValue());
                }
            }
        }
        return args;
    }

    protected void apply(IDeclarationBlock declarationBlock, IArgs args, IArgs targetArgs, IArgs scope) throws DeclarationException {
        IDeclarationElement[] declarations = declarationBlock.getDeclarationElements();
        int i = 0;
        while (i < declarations.length) {
            this.apply(declarations[i], i, args, targetArgs, scope);
            ++i;
        }
    }
}

