/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ChainedArgs
implements IArgs {
    private IArgs args;
    private IArgs fallbackArgs;

    public ChainedArgs(IArgs args, IArgs fallbackArgs) {
        this.args = args;
        this.fallbackArgs = fallbackArgs;
    }

    @Override
    public IArgs.IBinding add(Object object) {
        return this.args.add(object);
    }

    @Override
    public Iterator<IArgs.IBinding> bindings() {
        return new Iterator<IArgs.IBinding>(){
            private IArgs.IBinding current;
            private Iterator<IArgs.IBinding> argsIterator;
            private Iterator<IArgs.IBinding> fallbackIteratorIndexed;
            private Iterator<IArgs.IBinding> fallbackIteratorNamed;
            {
                this.argsIterator = ChainedArgs.this.args.bindings();
                this.fallbackIteratorIndexed = ChainedArgs.this.fallbackArgs.bindings();
                this.fallbackIteratorNamed = ChainedArgs.this.fallbackArgs.bindings();
            }

            @Override
            public boolean hasNext() {
                String name;
                if (this.current != null) {
                    return true;
                }
                IArgs.IBinding currentArg = null;
                IArgs.IBinding currentFallbackArg = null;
                if (this.argsIterator.hasNext()) {
                    currentArg = this.argsIterator.next();
                }
                if (this.fallbackIteratorIndexed.hasNext()) {
                    currentFallbackArg = this.fallbackIteratorIndexed.next();
                }
                if (currentArg == null && currentFallbackArg != null && currentFallbackArg.getName() == null) {
                    currentArg = ChainedArgs.this.args.add(null);
                }
                if (currentArg != null) {
                    name = currentArg.getName();
                    this.current = name == null ? (currentFallbackArg != null ? new Binding(currentArg, currentFallbackArg) : currentArg) : (ChainedArgs.this.fallbackArgs.isDefined(name) ? new Binding(currentArg, ChainedArgs.this.fallbackArgs.declare(name)) : currentArg);
                }
                while (this.current == null && this.fallbackIteratorNamed.hasNext()) {
                    currentFallbackArg = this.fallbackIteratorNamed.next();
                    name = currentFallbackArg.getName();
                    if (name == null || ChainedArgs.this.args.isDefined(name)) continue;
                    this.current = new Binding(ChainedArgs.this.args.declare(name), currentFallbackArg);
                }
                return false;
            }

            @Override
            public IArgs.IBinding next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IArgs.IBinding result = this.current;
                this.current = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void clear() {
        this.args.clear();
    }

    @Override
    public IArgs copy() {
        IArgs result = this.fallbackArgs.copy();
        for (String name : this.args.names()) {
            Object value = this.args.get(name);
            if (value instanceof IArgs) {
                result.put(name, (Object)((IArgs)value).copy());
                continue;
            }
            result.put(name, value);
        }
        return result;
    }

    @Override
    public IArgs.IBinding declare(String name) {
        return new Binding(this.args.declare(name), this.fallbackArgs.declare(name));
    }

    @Override
    public Object get(int index) {
        Object fallbackResult;
        Object result = this.args.get(index);
        if (result == null) {
            fallbackResult = this.fallbackArgs.get(index);
            if (fallbackResult instanceof IArgs) {
                result = Args.create();
                this.args.put(index, result);
            } else {
                result = fallbackResult;
            }
        }
        if (result instanceof IArgs && (fallbackResult = this.fallbackArgs.get(index)) instanceof IArgs) {
            result = null;
        }
        return result;
    }

    @Override
    public Object get(int index, Object defaultValue) {
        Object result = this.get(index);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    @Override
    public Object get(String name) {
        Object fallbackResult;
        Object result = this.args.get(name);
        if (result == null && !this.args.isDefined(name)) {
            fallbackResult = this.fallbackArgs.get(name);
            if (fallbackResult instanceof IArgs) {
                result = Args.create();
                this.args.put(name, result);
            } else {
                result = fallbackResult;
            }
        }
        if (result instanceof IArgs && (fallbackResult = this.fallbackArgs.get(name)) instanceof IArgs) {
            result = null;
        }
        return result;
    }

    @Override
    public Object get(String name, Object defaultValue) {
        Object result = this.get(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public IArgs getArgs() {
        return this.args;
    }

    public IArgs getFallbackArgs() {
        return this.fallbackArgs;
    }

    @Override
    public boolean isDefined(int index) {
        if (this.args.isDefined(index)) {
            return true;
        }
        return this.fallbackArgs.isDefined(index);
    }

    @Override
    public boolean isDefined(String name) {
        if (this.args.isDefined(name)) {
            return true;
        }
        return this.fallbackArgs.isDefined(name);
    }

    public boolean isIndexed() {
        return true;
    }

    public boolean isNamed() {
        return true;
    }

    public Set names() {
        HashSet<String> names = new HashSet<String>(this.args.names());
        names.addAll(this.fallbackArgs.names());
        return names;
    }

    @Override
    public IArgs.IBinding put(int index, Object value) {
        return this.args.put(index, value);
    }

    @Override
    public IArgs.IBinding put(String name, Object value) {
        return this.args.put(name, value);
    }

    @Override
    public int size() {
        return this.names().size();
    }

    public String toString() {
        return ArgTools.toString(this, "");
    }

    @Override
    public void undefine(int index) {
    }

    @Override
    public void undefine(String name) {
    }

    class Binding
    implements IArgs.IBinding {
        private final IArgs.IBinding argBinding;
        private final IArgs.IBinding fallbackBinding;

        public Binding(IArgs.IBinding argBinding, IArgs.IBinding fallbackBinding) {
            this.argBinding = argBinding;
            this.fallbackBinding = fallbackBinding;
        }

        @Override
        public String getName() {
            return this.argBinding.getName();
        }

        @Override
        public Object getValue() {
            Object fallbackValue;
            Object result = this.argBinding.getValue();
            if (result == null && !this.argBinding.isDefined()) {
                fallbackValue = this.fallbackBinding.getValue();
                if (fallbackValue instanceof IArgs) {
                    result = Args.create();
                    this.argBinding.setValue(result);
                } else {
                    result = fallbackValue;
                }
            }
            if (result instanceof IArgs && (fallbackValue = this.fallbackBinding.getValue()) instanceof IArgs) {
                result = null;
            }
            return result;
        }

        @Override
        public boolean isDefined() {
            return this.argBinding.isDefined() || this.fallbackBinding.isDefined();
        }

        @Override
        public void setName(String name) {
            this.argBinding.setName(name);
        }

        @Override
        public void setValue(Object value) {
            this.argBinding.setValue(value);
        }
    }
}

