/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.Declaration;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;

public class DeclarationBlock
extends Declaration
implements IDeclarationBlock {
    private IDeclarationElement[] declarations;

    public DeclarationBlock(Object declarationContext) {
        super(declarationContext);
        this.declarations = new IDeclarationElement[0];
    }

    public DeclarationBlock(Object declarationContext, IDeclarationElement[] declarations) {
        super(declarationContext);
        if (declarations == null) {
            throw new IllegalArgumentException("declarations can't be null");
        }
        this.declarations = declarations;
    }

    @Override
    public void addDeclarationElement(IDeclarationElement pDeclaration) {
        int i = 0;
        while (i < this.declarations.length) {
            IDeclarationElement declaration = this.declarations[i];
            if (declaration.getName().equals(pDeclaration.getName())) {
                this.declarations[i] = pDeclaration;
                return;
            }
            ++i;
        }
        IDeclarationElement[] newDeclarations = new IDeclarationElement[this.declarations.length + 1];
        System.arraycopy(this.declarations, 0, newDeclarations, 0, this.declarations.length);
        newDeclarations[this.declarations.length] = pDeclaration;
        this.declarations = newDeclarations;
    }

    @Override
    public void clear() {
        if (this.declarations.length == 0) {
            return;
        }
        this.declarations = new IDeclarationElement[0];
    }

    @Override
    public IDeclaration copy() {
        IDeclarationElement[] copyDeclarations = new IDeclarationElement[this.size()];
        int i = 0;
        while (i < this.declarations.length) {
            IDeclarationElement declaration = this.declarations[i];
            copyDeclarations[i] = (IDeclarationElement)declaration.copy();
            ++i;
        }
        return new DeclarationBlock(this.getDeclarationContext(), copyDeclarations);
    }

    @Override
    public IDeclarationElement getDeclarationElement(String name) {
        int i = 0;
        while (i < this.declarations.length) {
            IDeclarationElement declaration = this.declarations[i];
            if (declaration.getName().equals(name)) {
                return declaration;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IDeclarationElement[] getDeclarationElements() {
        return this.declarations;
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    @Override
    public void moveDown(IDeclarationElement declaration) {
        int i = 0;
        while (i < this.declarations.length - 1) {
            if (this.declarations[i] == declaration) {
                this.declarations[i] = this.declarations[i + 1];
                this.declarations[i + 1] = declaration;
                break;
            }
            ++i;
        }
    }

    @Override
    public void moveUp(IDeclarationElement declaration) {
        int i = 1;
        while (i < this.declarations.length) {
            if (this.declarations[i] == declaration) {
                this.declarations[i] = this.declarations[i - 1];
                this.declarations[i - 1] = declaration;
                break;
            }
            ++i;
        }
    }

    @Override
    public boolean removeDeclarationElement(IDeclarationElement declaration) {
        int i = 0;
        while (i < this.declarations.length) {
            if (this.declarations[i] == declaration) {
                IDeclarationElement[] newDeclarations = new IDeclarationElement[this.declarations.length - 1];
                System.arraycopy(this.declarations, 0, newDeclarations, 0, i);
                System.arraycopy(this.declarations, i + 1, newDeclarations, i, this.declarations.length - i - 1);
                this.declarations = newDeclarations;
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int size() {
        return this.declarations.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        IDeclarationElement[] iDeclarationElementArray = this.declarations;
        int n = this.declarations.length;
        int n2 = 0;
        while (n2 < n) {
            IDeclarationElement element = iDeclarationElementArray[n2];
            sb.append(element.toString());
            sb.append("\n");
            ++n2;
        }
        return sb.toString();
    }
}

