/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.IFunctorCallFactory;
import de.intarsys.tools.reflect.FieldAccessException;
import de.intarsys.tools.reflect.IFieldHandler;
import de.intarsys.tools.reflect.ObjectCreationException;

public class FunctorFieldHandler
implements IFieldHandler,
INotificationSupport,
IAttributeSupport {
    private IFunctor getter;
    private String name;
    private IFunctor setter;

    public FunctorFieldHandler() {
    }

    public FunctorFieldHandler(String name, IFunctor getter, IFunctor setter) {
        this.name = name;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.getter instanceof INotificationSupport) {
            ((INotificationSupport)((Object)this.getter)).addNotificationListener(type, listener);
        }
    }

    @Override
    public Object getAttribute(Object key) {
        if (this.getter instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.getter)).getAttribute(key);
        }
        return null;
    }

    public IFunctor getGetter() {
        return this.getter;
    }

    public String getName() {
        return this.name;
    }

    public IFunctor getSetter() {
        return this.setter;
    }

    @Override
    public Object getValue(Object object) throws FieldAccessException {
        IFunctorCall call;
        if (this.getter == null) {
            return null;
        }
        if (object instanceof IFunctorCallFactory) {
            try {
                call = ((IFunctorCallFactory)object).createFunctorCall(this.getter, object, Args.create());
            }
            catch (ObjectCreationException e) {
                throw new FieldAccessException(this.getName(), (Throwable)e);
            }
        } else {
            call = new FunctorCall(object, Args.create());
        }
        try {
            return this.getter.perform(call);
        }
        catch (FunctorInvocationException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw new FieldAccessException(this.getName(), cause);
        }
    }

    @Override
    public Object removeAttribute(Object key) {
        if (this.getter instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.getter)).removeAttribute(key);
        }
        return null;
    }

    @Override
    public void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.getter instanceof INotificationSupport) {
            ((INotificationSupport)((Object)this.getter)).removeNotificationListener(type, listener);
        }
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        if (this.getter instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.getter)).setAttribute(key, value);
        }
        return null;
    }

    public void setGetter(IFunctor getter) {
        this.getter = getter;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSetter(IFunctor setter) {
        this.setter = setter;
    }

    @Override
    public Object setValue(Object object, Object value) throws FieldAccessException {
        IFunctorCall call;
        if (this.setter == null) {
            return null;
        }
        if (object instanceof IFunctorCallFactory) {
            try {
                call = ((IFunctorCallFactory)object).createFunctorCall(this.setter, object, Args.createIndexed(value));
            }
            catch (ObjectCreationException e) {
                throw new FieldAccessException(this.getName(), (Throwable)e);
            }
        } else {
            call = new FunctorCall(object, Args.createIndexed(value));
        }
        try {
            return this.setter.perform(call);
        }
        catch (FunctorInvocationException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw new FieldAccessException(this.getName(), cause);
        }
    }
}

