/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor.common;

import de.intarsys.tools.functor.ArgumentDeclaration;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;
import de.intarsys.tools.functor.IDeclarationSupport;
import de.intarsys.tools.string.Converter;

public class DeclarationTools {
    public static void addDeclarations(IDeclarationBlock target, IDeclarationBlock source) {
        IDeclarationElement[] iDeclarationElementArray = source.getDeclarationElements();
        int n = iDeclarationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDeclarationElement element = iDeclarationElementArray[n2];
            target.addDeclarationElement(element);
            ++n2;
        }
    }

    public static Object getDeclarationDefaultValue(IDeclarationBlock declarationBlock, String path, IArgs scope) {
        ArgumentDeclaration declaration = (ArgumentDeclaration)DeclarationTools.getDeclarationElement(declarationBlock, path);
        if (declaration == null) {
            return null;
        }
        try {
            return declaration.getDefaultValue(scope);
        }
        catch (FunctorInvocationException e) {
            return null;
        }
    }

    public static boolean getDeclarationDefaultValueAsBoolean(IDeclarationBlock declarationBlock, String path, IArgs scope) {
        Object value = DeclarationTools.getDeclarationDefaultValue(declarationBlock, path, scope);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Converter.asBoolean(String.valueOf(value), false);
    }

    public static int getDeclarationDefaultValueAsInt(IDeclarationBlock declarationBlock, String path, IArgs scope) {
        Object value = DeclarationTools.getDeclarationDefaultValue(declarationBlock, path, scope);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Converter.asInteger(String.valueOf(value), 0);
    }

    public static String getDeclarationDefaultValueAsString(IDeclarationBlock declarationBlock, String path, IArgs scope) {
        Object value = DeclarationTools.getDeclarationDefaultValue(declarationBlock, path, scope);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public static IDeclarationElement getDeclarationElement(IDeclarationBlock declarationBlock, String path) {
        IDeclarationElement result = null;
        String[] segments = path.split("\\.");
        IDeclarationBlock currentBlock = declarationBlock;
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            result = currentBlock.getDeclarationElement(segment);
            if (result instanceof IDeclarationBlock) {
                currentBlock = (IDeclarationBlock)((Object)result);
            } else if (result instanceof IDeclarationSupport) {
                currentBlock = ((IDeclarationSupport)((Object)result)).getDeclarationBlock();
            } else if (i < segments.length - 1) {
                return null;
            }
            ++i;
        }
        return result;
    }

    public static IDeclarationElement removeDeclarationElement(IDeclarationBlock declarationBlock, String path) {
        IDeclarationElement result = null;
        String[] segments = path.split("\\.");
        IDeclarationBlock currentBlock = declarationBlock;
        int i = 0;
        while (i < segments.length) {
            String segment = segments[i];
            result = currentBlock.getDeclarationElement(segment);
            if (++i >= segments.length) continue;
            if (result instanceof IDeclarationBlock) {
                currentBlock = (IDeclarationBlock)((Object)result);
                continue;
            }
            if (result instanceof IDeclarationSupport) {
                currentBlock = ((IDeclarationSupport)((Object)result)).getDeclarationBlock();
                continue;
            }
            return null;
        }
        currentBlock.removeDeclarationElement(result);
        return result;
    }
}

