/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.geometry;

import de.intarsys.tools.geometry.IShapeWrapper;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class TransformedShape
implements Shape,
IShapeWrapper,
Cloneable {
    protected static final AffineTransform IDENTITY = new AffineTransform();
    private final Shape baseShape;
    private Shape resultShape;

    protected TransformedShape(Shape shape) {
        this.baseShape = shape;
        this.resultShape = null;
    }

    protected TransformedShape(TransformedShape shape) {
        this.baseShape = shape.baseShape;
        this.resultShape = shape.resultShape;
    }

    protected abstract Shape apply();

    public abstract Object clone();

    @Override
    public boolean contains(double x, double y) {
        return this.getShape().contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.getShape().contains(x, y, w, h);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.getShape().contains(p);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.getShape().contains(r);
    }

    @Override
    public Shape getBaseShape() {
        return this.baseShape;
    }

    @Override
    public Rectangle getBounds() {
        return this.getShape().getBounds();
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getShape().getBounds2D();
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.getShape().getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getShape().getPathIterator(at, flatness);
    }

    public Shape getShape() {
        if (this.resultShape == null) {
            this.resultShape = this.apply();
        }
        return this.resultShape;
    }

    public abstract AffineTransform getTransform();

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.getShape().intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.getShape().intersects(r);
    }

    public void invalidate() {
        this.resultShape = null;
    }
}

