/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.OutputFormat;
import de.intarsys.tools.infoset.XMLWriter;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;

public class DocumentTools {
    public static boolean equals(IDocument a, IDocument b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        IElement aRoot = a.getRootElement();
        IElement bRoot = b.getRootElement();
        return DocumentTools.equals(aRoot, bRoot);
    }

    public static boolean equals(IElement a, IElement b) {
        String name;
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        Iterator<String> itNames = a.attributeNames();
        HashSet<String> visited = new HashSet<String>();
        while (itNames.hasNext()) {
            name = itNames.next();
            if (!a.attributeValue(name, null).equals(b.attributeValue(name, null))) {
                return false;
            }
            visited.add(name);
        }
        itNames = b.attributeNames();
        while (itNames.hasNext()) {
            name = itNames.next();
            if (visited.contains(name) || a.attributeValue(name, null).equals(b.attributeValue(name, null))) continue;
            return false;
        }
        Iterator<IElement> itElementA = a.elementIterator();
        Iterator<IElement> itElementB = b.elementIterator();
        while (itElementA.hasNext() && itElementB.hasNext()) {
            IElement childB;
            IElement childA = itElementA.next();
            if (DocumentTools.equals(childA, childB = itElementB.next())) continue;
            return false;
        }
        if (itElementA.hasNext()) {
            return false;
        }
        return !itElementB.hasNext();
    }

    public static IDocument parse(ILocator locator) throws IOException {
        InputStream is = null;
        try {
            is = locator.getInputStream();
            IDocument iDocument = ElementFactory.get().parse(is);
            return iDocument;
        }
        finally {
            StreamTools.close(is);
        }
    }

    public static void save(IDocument doc, ILocator locator) throws IOException {
        Writer w = null;
        try {
            w = locator.getWriter();
            DocumentTools.save(doc, w);
        }
        finally {
            StreamTools.close(w);
        }
    }

    public static void save(IDocument doc, Writer w) throws IOException {
        XMLWriter xmlw = new XMLWriter(w, OutputFormat.createPrettyPrint());
        xmlw.write(doc);
    }
}

