/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementChildrenArgsAdapter;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ElementArgsAdapter
implements IArgs {
    private final IElement element;

    public ElementArgsAdapter(IElement element) {
        this.element = element;
    }

    @Override
    public IArgs.IBinding add(Object object) {
        throw new UnsupportedOperationException("can't write");
    }

    @Override
    public Iterator<IArgs.IBinding> bindings() {
        Set<String> names = this.names();
        return new ConversionIterator<String, IArgs.IBinding>(names.iterator()){

            @Override
            protected IArgs.IBinding createTargetObject(String sourceObject) {
                return new Binding(sourceObject);
            }
        };
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("can't write");
    }

    @Override
    public IArgs copy() {
        return new ElementArgsAdapter(this.element);
    }

    @Override
    public IArgs.IBinding declare(String name) {
        return new Binding(name);
    }

    @Override
    public Object get(int index) {
        return null;
    }

    @Override
    public Object get(int index, Object defaultValue) {
        return defaultValue;
    }

    @Override
    public Object get(String name) {
        IAttribute result = this.element.attribute(name);
        if (result == null) {
            if (this.element.hasElements(name)) {
                return new ElementChildrenArgsAdapter(this.element, name);
            }
            return null;
        }
        return result.getValue();
    }

    @Override
    public Object get(String name, Object defaultValue) {
        IAttribute result = this.element.attribute(name);
        if (result == null) {
            if (this.element.hasElements(name)) {
                return new ElementChildrenArgsAdapter(this.element, name);
            }
            return defaultValue;
        }
        return result.getValue();
    }

    @Override
    public boolean isDefined(int index) {
        return false;
    }

    @Override
    public boolean isDefined(String name) {
        return this.element.hasElements(name) || this.element.hasAttribute(name);
    }

    @Override
    public Set<String> names() {
        HashSet<String> names = new HashSet<String>();
        Iterator<IElement> elements = this.element.elementIterator();
        while (elements.hasNext()) {
            IElement element = elements.next();
            names.add(element.getName());
        }
        Iterator<String> attributes = this.element.attributeNames();
        while (attributes.hasNext()) {
            String name = attributes.next();
            names.add(name);
        }
        return names;
    }

    @Override
    public IArgs.IBinding put(int index, Object value) {
        throw new UnsupportedOperationException("can't write to ArgsAdapter");
    }

    @Override
    public IArgs.IBinding put(String name, Object value) {
        throw new UnsupportedOperationException("can't write to ArgsAdapter");
    }

    @Override
    public int size() {
        return this.names().size();
    }

    public String toString() {
        return ArgTools.toString(this, "");
    }

    @Override
    public void undefine(int index) {
        throw new UnsupportedOperationException("can't write to ArgsAdapter");
    }

    @Override
    public void undefine(String name) {
        throw new UnsupportedOperationException("can't write to ArgsAdapter");
    }

    protected class Binding
    implements IArgs.IBinding {
        private String name;

        public Binding(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return ElementArgsAdapter.this.get(this.name);
        }

        @Override
        public boolean isDefined() {
            return ElementArgsAdapter.this.isDefined(this.name);
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public void setValue(Object value) {
            ElementArgsAdapter.this.put(this.name, value);
        }
    }
}

