/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.proxy.IProxy;
import de.intarsys.tools.reflect.ObjectCreationException;

public class ElementObjectProxy
implements IElementConfigurable,
IProxy {
    private IElement element;
    private Object realized;
    private final Class proxyClass;
    private final String proxyClassAttribute;
    private final ClassLoader classLoader;

    public ElementObjectProxy() {
        this.proxyClass = Object.class;
        this.proxyClassAttribute = "class";
        this.classLoader = this.getClass().getClassLoader();
    }

    public ElementObjectProxy(Class pProxyClass, IElement pElement, ClassLoader pClassLoader) {
        this.element = pElement;
        this.proxyClass = pProxyClass;
        this.classLoader = pClassLoader;
        this.proxyClassAttribute = "class";
    }

    public ElementObjectProxy(Class pProxyClass, IElement pElement, String classAttribute, ClassLoader pClassLoader) {
        this.element = pElement;
        this.proxyClass = pProxyClass;
        this.classLoader = pClassLoader;
        this.proxyClassAttribute = classAttribute;
    }

    protected Object basicGetRealized() {
        return this.realized;
    }

    @Override
    public void configure(IElement pElement) {
        this.element = pElement;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public IElement getElement() {
        return this.element;
    }

    public Class getProxyClass() {
        return this.proxyClass;
    }

    public String getProxyClassAttribute() {
        return this.proxyClassAttribute;
    }

    public synchronized Object getRealized() {
        if (this.realized == null) {
            try {
                this.realized = this.realize();
            }
            catch (ObjectCreationException e) {
                throw new TunnelingException(e);
            }
        }
        return this.realized;
    }

    protected Object realize() throws ObjectCreationException {
        Object object = ElementTools.createObject(this.getElement(), this.getProxyClassAttribute(), this.getProxyClass(), this.getClassLoader());
        return object;
    }
}

