/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.bean.BeanContainer;
import de.intarsys.tools.codeexit.CodeExit;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.component.IInitializeable;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgumentDeclarator;
import de.intarsys.tools.functor.DeclarationBlock;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorFieldHandler;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.common.DeclarationIO;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.infoset.IElementSerializable;
import de.intarsys.tools.infoset.PACKAGE;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IClassLoaderAccess;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import de.intarsys.tools.reflect.IFieldHandler;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;
import java.awt.Color;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ElementTools {
    public static final String PROPERTY_REMOVE = "remove";
    public static final String PROPERTY_INSERT = "insert";
    public static final String ELEMENT_SET = "set";
    public static final String PROPERTY_SET = "set";
    public static final String ELEMENT_GET = "get";
    public static final String ATTR_REF = "ref";
    public static final String ELEMENT_ACCESSOR = "accessor";
    public static final String ELEMENT_NULL = "null";
    public static final String ELEMENT_ARGS = "args";
    public static final String ELEMENT_VALUE = "value";
    public static final String ELEMENT_OBJECT = "object";
    public static final String ATTR_TYPE = "type";
    public static final String ELEMENT_PERFORM = "perform";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_FACTORY = "factory";
    private static final Logger Log = PACKAGE.Log;
    private static Pattern splitPattern = Pattern.compile("\\.");
    public static final String ATTR_NAME = "name";
    public static final String ELEMENT_IMPLEMENTATION = "implementation";
    public static final String ELEMENT_METHOD = "method";

    protected static InvocationHandler basicCreateInvocationHandler(IElement element, Class[] clazzes, ClassLoader loader) throws ObjectCreationException {
        return new ElementProxyInvocationHandler(element, clazzes, loader);
    }

    protected static Object basicCreateProxy(IElement element, Class[] clazzes, ClassLoader loader) throws ObjectCreationException {
        Class[] extendedClasses = new Class[clazzes.length + 1];
        System.arraycopy(clazzes, 0, extendedClasses, 0, clazzes.length);
        extendedClasses[extendedClasses.length - 1] = IAttributeSupport.class;
        InvocationHandler handler = ElementTools.basicCreateInvocationHandler(element, extendedClasses, loader);
        return Proxy.newProxyInstance(loader, extendedClasses, handler);
    }

    protected static Class basicCreateProxyClass(IElement element, Class[] clazzes, ClassLoader loader) throws ObjectCreationException {
        Class[] extendedClasses = new Class[clazzes.length + 1];
        System.arraycopy(clazzes, 0, extendedClasses, 0, clazzes.length);
        extendedClasses[extendedClasses.length - 1] = IAttributeSupport.class;
        return Proxy.getProxyClass(loader, extendedClasses);
    }

    public static void copy(IElement to, IElement from) {
        ElementTools.copyAttributes(to, from);
        ElementTools.copyElements(to, from);
        ElementTools.copyText(to, from);
    }

    public static void copyAttributes(IElement to, IElement from) {
        Iterator<String> iter = from.attributeNames();
        while (iter.hasNext()) {
            String name = iter.next();
            to.setAttributeTemplate(name, from.attributeTemplate(name));
        }
    }

    public static void copyElements(IElement to, IElement from) {
        Iterator<IElement> iter = from.elementIterator();
        while (iter.hasNext()) {
            IElement child = iter.next();
            IElement newTo = to.newElement(from.getName());
            ElementTools.copy(newTo, child);
        }
    }

    public static void copyText(IElement to, IElement from) {
        to.setText(from.getText());
    }

    public static <T> Class<T> createClass(IElement element, String classAttribute, Class<T> expectedClass, Object context) throws ObjectCreationException {
        if (element == null) {
            return null;
        }
        String className = element.attributeValue(classAttribute, null);
        if (StringTools.isEmpty(className)) {
            return null;
        }
        ClassLoader classLoader = ElementTools.getClassLoader(context, expectedClass);
        String[] classNames = className.split("\\;");
        Class[] clazzes = new Class[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            String tempName = classNames[i].trim();
            try {
                clazzes[i] = Class.forName(tempName, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new ObjectCreationException("class '" + className + "' not found", (Throwable)e);
            }
            ++i;
        }
        Class clazz = clazzes.length > 1 ? ElementTools.basicCreateProxyClass(element, clazzes, classLoader) : clazzes[0];
        return clazz;
    }

    protected static IFieldHandler createFieldHandler(IElement element, Object owner, Object context) throws ObjectCreationException {
        IElement setElement;
        if (element == null) {
            return null;
        }
        if (element.attributeValue(ATTR_CLASS, null) != null || element.attributeValue(ATTR_FACTORY, null) != null) {
            return ElementTools.createObject(element, IFieldHandler.class, context);
        }
        FunctorFieldHandler tempAccessor = new FunctorFieldHandler();
        IElement getElement = element.element(ELEMENT_GET);
        if (getElement != null) {
            tempAccessor.setGetter(ElementTools.createFunctor(owner, getElement, null, context));
        }
        if ((setElement = element.element("set")) != null) {
            tempAccessor.setSetter(ElementTools.createFunctor(owner, setElement, null, context));
        }
        tempAccessor.setName(element.attributeValue(ATTR_NAME, "unknown"));
        return tempAccessor;
    }

    public static IFunctor createFunctor(Object owner, IElement element, String role, Object context) throws ObjectCreationException {
        if (element == null) {
            return null;
        }
        IFunctor<Object> functor = null;
        IElement codeExitElement = element.element(ELEMENT_PERFORM);
        if (codeExitElement != null) {
            functor = CodeExit.createFromElement(codeExitElement);
            ((CodeExit)functor).setOwner(owner);
            ((CodeExit)functor).setClassLoader(ElementTools.getClassLoader(context, CodeExit.class));
        } else {
            functor = ElementTools.createObject(element, role, IFunctor.class, context);
        }
        return functor;
    }

    public static <T> T createObject(IElement element, Class<T> expectedClass, Object context) throws ObjectCreationException {
        return ElementTools.createObject(element, null, expectedClass, context);
    }

    public static <T> T createObject(IElement element, String role, Class<T> expectedClass, Object context) throws ObjectCreationException {
        String attributeName;
        String target;
        if (element == null) {
            return null;
        }
        if (role == null) {
            role = "";
        }
        if (role.length() > 0 && (target = element.attributeValue(attributeName = role, null)) != null) {
            return ElementTools.createObjectFromClass(element, target, expectedClass, context);
        }
        attributeName = String.valueOf(role) + ATTR_REF;
        target = element.attributeValue(attributeName, null);
        if (target != null) {
            return ElementTools.createObjectFromContainer(element, target, expectedClass, context);
        }
        attributeName = String.valueOf(role) + ATTR_CLASS;
        target = element.attributeValue(attributeName, null);
        if (target != null) {
            return ElementTools.createObjectFromClass(element, target, expectedClass, context);
        }
        attributeName = String.valueOf(role) + ATTR_FACTORY;
        target = element.attributeValue(attributeName, null);
        if (target != null) {
            return ElementTools.createObjectFromFactory(element, target, expectedClass, context);
        }
        Iterator<IElement> it = element.elementIterator();
        if (it.hasNext()) {
            return ElementTools.createObjectChild(null, it.next(), expectedClass, context);
        }
        throw new ObjectCreationException("can't create object (no 'ref', 'class' or 'factory'");
    }

    public static <T> T createObjectChild(Object owner, IElement element, Class<T> expectedClass, Object context) throws ObjectCreationException {
        if (element == null) {
            return null;
        }
        String name = element.getName();
        if (ELEMENT_OBJECT.equals(name)) {
            return ElementTools.createObject(element, expectedClass, context);
        }
        if (ELEMENT_VALUE.equals(name)) {
            String value = element.getText();
            String typeName = element.attributeValue(ATTR_TYPE, null);
            return (T)ObjectTools.convert(value, typeName, ElementTools.getClassLoader(context, expectedClass));
        }
        if (ELEMENT_ARGS.equals(name)) {
            DeclarationBlock block = new DeclarationBlock(owner);
            new DeclarationIO().deserializeDeclarationElements(block, element, false);
            Args value = Args.create();
            try {
                new ArgumentDeclarator().apply(block, value);
            }
            catch (DeclarationException e) {
                throw new ObjectCreationException(e);
            }
            String typeName = element.attributeValue(ATTR_TYPE, null);
            return (T)ObjectTools.convert(value, typeName, ElementTools.getClassLoader(context, expectedClass));
        }
        if (ELEMENT_NULL.equals(name)) {
            return null;
        }
        if (ELEMENT_PERFORM.equals(name)) {
            CodeExit<?> functor = CodeExit.createFromElement(element);
            functor.setOwner(owner);
            functor.setClassLoader(ElementTools.getClassLoader(context, expectedClass));
            try {
                return (T)functor.perform(FunctorCall.noargs(owner));
            }
            catch (FunctorInvocationException e) {
                throw new ObjectCreationException(e);
            }
        }
        if (ELEMENT_ACCESSOR.equals(name)) {
            return (T)ElementTools.createFieldHandler(element, owner, context);
        }
        throw new ObjectCreationException("unknown value element '" + name + "'");
    }

    protected static <T> T createObjectFromClass(IElement element, String className, Class<T> expectedClass, Object context) throws ObjectCreationException {
        if (className == null) {
            throw new ObjectCreationException("class name missing");
        }
        ClassLoader classLoader = ElementTools.getClassLoader(context, expectedClass);
        String[] classNames = className.split("\\;");
        Class[] clazzes = new Class[classNames.length];
        int i = 0;
        while (i < classNames.length) {
            String tempName = classNames[i].trim();
            try {
                clazzes[i] = Class.forName(tempName, false, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new ObjectCreationException("class '" + className + "' not found", (Throwable)e);
            }
            ++i;
        }
        Object object = clazzes.length > 1 || clazzes[0].isInterface() ? ElementTools.basicCreateProxy(element, clazzes, classLoader) : ObjectTools.createObject(clazzes[0], expectedClass);
        try {
            if (object instanceof IContextSupport) {
                ((IContextSupport)object).setContext(context);
            }
            if (object instanceof IClassLoaderAccess) {
                ((IClassLoaderAccess)object).setClassLoader(classLoader);
            }
            if (object instanceof IElementConfigurable) {
                ((IElementConfigurable)object).configure(element);
            }
            ElementTools.setProperties(object, element, classLoader);
            if (object instanceof IInitializeable) {
                ((IInitializeable)object).initializeAfterConstruction();
            }
            ElementTools.postProcess(object);
        }
        catch (ObjectCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
        return (T)object;
    }

    protected static <T> T createObjectFromContainer(IElement element, String refName, Class<T> expectedClass, Object context) throws ObjectCreationException {
        T object = BeanContainer.get().lookupBean(refName, expectedClass);
        try {
            if (object instanceof IElementConfigurable) {
                ((IElementConfigurable)object).configure(element);
            }
            ElementTools.setProperties(object, element, context);
        }
        catch (ObjectCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObjectCreationException(e);
        }
        return object;
    }

    protected static <T> T createObjectFromFactory(IElement element, String factoryName, Class<T> expectedClass, Object context) throws ObjectCreationException {
        if (factoryName == null) {
            throw new ObjectCreationException("factory name missing");
        }
        ClassLoader classLoader = ElementTools.getClassLoader(context, expectedClass);
        IFactory factory = Outlet.get().lookupFactory(factoryName);
        if (factory == null) {
            try {
                factory = ObjectTools.createObject(factoryName, IFactory.class, classLoader);
                Outlet.get().registerFactory(factory);
                Log.log(Level.INFO, "created default factory '" + factoryName + "'");
            }
            catch (Exception e) {
                throw new ObjectCreationException("factory '" + factoryName + "' missing");
            }
        }
        Args args = Args.create();
        args.put("context", context);
        args.put("configuration", (Object)element);
        return factory.createInstance(args);
    }

    public static <T> T createPropertyValue(Object owner, IElement element, Class<T> expectedClass, Object context) throws ObjectCreationException {
        IElement valueElement = null;
        Iterator<IElement> itElement = element.elementIterator();
        if (itElement.hasNext()) {
            valueElement = itElement.next();
            if (itElement.hasNext()) {
                throw new ObjectCreationException("too many children");
            }
            return ElementTools.createObjectChild(owner, valueElement, expectedClass, context);
        }
        String ref = element.attributeValue(ATTR_REF, null);
        if (ref != null) {
            return BeanContainer.get().lookupBean(ref, expectedClass);
        }
        String value = element.attributeValue(ELEMENT_VALUE, null);
        String typeName = element.attributeValue(ATTR_TYPE, null);
        return (T)ObjectTools.convert(value, typeName, ElementTools.getClassLoader(context, null));
    }

    public static boolean getBool(IElement element, String attributeName, boolean defaultValue) {
        return ElementTools.getBoolean(element, attributeName, defaultValue);
    }

    public static boolean getBoolean(IElement element, String attributeName, boolean defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static char[] getCharArray(IElement element, String attributeName, char[] defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value == null) {
            return defaultValue;
        }
        return value.toCharArray();
    }

    protected static <T> ClassLoader getClassLoader(Object context, Class<T> expectedClass) {
        ClassLoader classLoader = null;
        if (context instanceof ClassLoader) {
            classLoader = (ClassLoader)context;
        } else if (context instanceof IClassLoaderSupport) {
            classLoader = ((IClassLoaderSupport)context).getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null && expectedClass != null) {
            classLoader = expectedClass.getClassLoader();
        }
        return classLoader;
    }

    public static Color getColor(IElement element, String name, Color defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String optionValue = element.attributeValue(name, null);
        if (optionValue == null) {
            return defaultValue;
        }
        try {
            return Color.decode(optionValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double getDouble(IElement element, String attributeName, double defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static <T extends EnumItem> T getEnumItem(IElement element, String attributeName, EnumMeta<T> meta) {
        String id = ElementTools.getString(element, attributeName, null);
        return meta.getItemOrDefault(id);
    }

    public static <T extends EnumItem> T getEnumItem(IElement element, String attributeName, EnumMeta<T> meta, T defaultValue) {
        String id = ElementTools.getString(element, attributeName, null);
        T result = null;
        if (id != null) {
            result = meta.getItem(id);
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static float getFloat(IElement element, String attributeName, float defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getInt(IElement element, String attributeName, int defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long getLong(IElement element, String attributeName, long defaultValue) {
        String value = null;
        if (element != null) {
            value = element.attributeValue(attributeName, null);
        }
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getPathBoolean(IElement element, String path, boolean defaultValue) {
        IElement nextElement = element;
        String[] split = splitPattern.split(path, 0);
        int count = split.length - 1;
        int i = 0;
        while (nextElement != null && i < count) {
            nextElement = nextElement.element(split[i]);
            ++i;
        }
        return ElementTools.getBoolean(nextElement, split[i], defaultValue);
    }

    public static double getPathDouble(IElement element, String path, double defaultValue) {
        IElement nextElement = element;
        String[] split = splitPattern.split(path, 0);
        int count = split.length - 1;
        int i = 0;
        while (nextElement != null && i < count) {
            nextElement = nextElement.element(split[i]);
            ++i;
        }
        return ElementTools.getDouble(nextElement, split[i], defaultValue);
    }

    public static float getPathFloat(IElement element, String path, float defaultValue) {
        IElement nextElement = element;
        String[] split = splitPattern.split(path, 0);
        int count = split.length - 1;
        int i = 0;
        while (nextElement != null && i < count) {
            nextElement = nextElement.element(split[i]);
            ++i;
        }
        return ElementTools.getFloat(nextElement, split[i], defaultValue);
    }

    public static int getPathInt(IElement element, String path, int defaultValue) {
        IElement nextElement = element;
        String[] split = splitPattern.split(path, 0);
        int count = split.length - 1;
        int i = 0;
        while (nextElement != null && i < count) {
            nextElement = nextElement.element(split[i]);
            ++i;
        }
        return ElementTools.getInt(nextElement, split[i], defaultValue);
    }

    public static String getPathString(IElement element, String path, String defaultValue) {
        IElement nextElement = element;
        String[] split = splitPattern.split(path, 0);
        int count = split.length - 1;
        int i = 0;
        while (nextElement != null && i < count) {
            nextElement = nextElement.element(split[i]);
            ++i;
        }
        return ElementTools.getString(nextElement, split[i], defaultValue);
    }

    public static String getString(IElement element, String attributeName, String defaultValue) {
        if (element != null) {
            return element.attributeValue(attributeName, defaultValue);
        }
        return defaultValue;
    }

    public static IElement parseElement(String value) throws IOException {
        StringReader reader = new StringReader(value);
        return ElementFactory.get().parse(reader).getRootElement();
    }

    protected static void postProcess(Object object) throws ObjectCreationException {
        Class<?> clazz = object.getClass();
        Method[] methods = clazz.getMethods();
        Method tempMethod = null;
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getAnnotation(PostConstruct.class) != null) {
                tempMethod = method;
            }
            ++n2;
        }
        if (tempMethod != null) {
            try {
                tempMethod.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new ObjectCreationException(e);
            }
        }
    }

    public static void serialize(Object value, IElement element, String role) throws ElementSerializationException {
        if (value == null) {
            return;
        }
        IElement newElement = element.newElement(role);
        if (value instanceof IElementSerializable) {
            ((IElementSerializable)value).serialize(newElement);
            newElement.setName(role);
        } else {
            newElement.setAttributeValue(ATTR_CLASS, value.getClass().getName());
        }
    }

    public static void setCDATA(IElement element, String value) {
        String cdata = "<![CDATA[" + value + "]]>";
        element.setText(cdata);
    }

    public static void setProperties(Object object, IElement element, Object context) throws FieldException, ObjectCreationException, FunctorInvocationException {
        Iterator<IElement> it = element.elementIterator("property");
        while (it.hasNext()) {
            IElement propertyElement = it.next();
            ElementTools.setProperty(object, propertyElement, context);
        }
    }

    public static void setProperty(Object object, IElement element, Object context) throws FieldException, ObjectCreationException, FunctorInvocationException {
        String property = element.attributeValue(ATTR_NAME, null);
        String operation = element.attributeValue("operation", "set");
        Object value = ElementTools.createPropertyValue(object, element, Object.class, context);
        if ("set".equals(operation)) {
            ObjectTools.set(object, property, value);
        } else if (PROPERTY_INSERT.equals(operation)) {
            ObjectTools.insert(object, property, value);
        } else if (PROPERTY_REMOVE.equals(operation)) {
            ObjectTools.remove(object, property, value);
        } else {
            throw new ObjectCreationException("unknown property operation '" + operation + "'");
        }
    }

    public static IElement toElement(IArgs args) {
        IDocument document = ElementFactory.get().createDocument();
        return ElementTools.toElement(document, null, "arg", args);
    }

    protected static IElement toElement(IDocument document, IElement parent, String parentName, IArgs args) {
        Iterator<IArgs.IBinding> it = args.bindings();
        IElement argsElement = null;
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            String name = binding.getName();
            Object value = binding.getValue();
            if (value == null) continue;
            if (name != null && argsElement == null) {
                argsElement = parent == null ? ElementFactory.get().createElement(parentName) : parent.newElement(parentName);
            }
            if (value instanceof IArgs) {
                if (name == null) {
                    ElementTools.toElement(document, parent, parentName, (IArgs)value);
                    continue;
                }
                ElementTools.toElement(document, argsElement, name, (IArgs)value);
                continue;
            }
            if (name == null) continue;
            String string = String.valueOf(value);
            argsElement.setAttributeValue(name, string);
        }
        if (parent == null && argsElement == null) {
            argsElement = ElementFactory.get().createElement(parentName);
        }
        return argsElement;
    }

    public static void write(ContentHandler handler, IElement element) throws SAXException {
        ElementTools.writeElementStart(handler, element);
        ElementTools.writeElementContent(handler, element);
        ElementTools.writeElementEnd(handler, element);
    }

    protected static void writeElementContent(ContentHandler handler, IElement element) throws SAXException {
        ElementTools.writeElementText(handler, element);
        Iterator<IElement> iter = element.elementIterator();
        while (iter.hasNext()) {
            IElement child = iter.next();
            ElementTools.write(handler, child);
        }
    }

    protected static void writeElementEnd(ContentHandler handler, IElement element) throws SAXException {
        handler.endElement(null, element.getName(), null);
    }

    protected static void writeElementStart(ContentHandler handler, IElement element) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        Iterator<String> iter = element.attributeNames();
        while (iter.hasNext()) {
            String name = iter.next();
            attributes.addAttribute("", name, name, "CDATA", element.attributeTemplate(name));
        }
        handler.startElement("", element.getName(), element.getName(), attributes);
    }

    protected static void writeElementText(ContentHandler handler, IElement element) throws SAXException {
        if (element.getText() != null) {
            char[] chars = element.getText().toCharArray();
            handler.characters(chars, 0, chars.length);
        }
    }

    static class ElementProxyInvocationHandler
    implements InvocationHandler,
    IAttributeSupport {
        private AttributeMap attributes;
        private Map<String, IFunctor> functors = new HashMap<String, IFunctor>();

        public ElementProxyInvocationHandler(IElement element, Class[] clazzes, ClassLoader loader) throws ObjectCreationException {
            this.createFunctors(element, clazzes, loader);
        }

        protected void createFunctors(IElement element, Class[] clazzes, ClassLoader loader) throws ObjectCreationException {
            IElement implementation = element.element(ElementTools.ELEMENT_IMPLEMENTATION);
            if (implementation != null) {
                Iterator<IElement> it = implementation.elementIterator(ElementTools.ELEMENT_METHOD);
                while (it.hasNext()) {
                    IElement methodElement = it.next();
                    String name = methodElement.attributeValue(ElementTools.ATTR_NAME, null);
                    IFunctor functor = ElementTools.createFunctor(this, methodElement, null, loader);
                    this.functors.put(name, functor);
                }
            }
            IFunctor tempFunctor = new IFunctor(){

                public Object perform(IFunctorCall call) throws FunctorInvocationException {
                    return ElementProxyInvocationHandler.this.getAttribute(call.getArgs().get(0));
                }
            };
            this.functors.put("getAttribute", tempFunctor);
            tempFunctor = new IFunctor(){

                public Object perform(IFunctorCall call) throws FunctorInvocationException {
                    return ElementProxyInvocationHandler.this.setAttribute(call.getArgs().get(0), call.getArgs().get(1));
                }
            };
            this.functors.put("setAttribute", tempFunctor);
            tempFunctor = new IFunctor(){

                public Object perform(IFunctorCall call) throws FunctorInvocationException {
                    return ElementProxyInvocationHandler.this.removeAttribute(call.getArgs().get(0));
                }
            };
            this.functors.put("removeAttribute", tempFunctor);
        }

        @Override
        public Object getAttribute(Object key) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(key);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            IFunctor functor = this.functors.get(name);
            if (functor == null) {
                return null;
            }
            Args functorArgs = new Args(args);
            FunctorCall call = new FunctorCall(proxy, functorArgs);
            return functor.perform(call);
        }

        @Override
        public Object removeAttribute(Object key) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.remove(key);
        }

        @Override
        public Object setAttribute(Object key, Object o) {
            if (this.attributes == null) {
                this.attributes = new AttributeMap();
            }
            return this.attributes.put(key, o);
        }
    }
}

