/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.infoset.StandardDocument;
import de.intarsys.tools.infoset.StandardElement;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class StandardContentHandler
extends DefaultHandler {
    private StringBuilder sb = new StringBuilder();
    private StandardDocument document;
    private StandardElement element;
    private Locator documentLocator = null;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.sb.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.element != null) {
            throw new SAXException("document has open elements");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.element.setText(this.sb.toString());
        this.sb.setLength(0);
        this.element = this.element.getParent();
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        super.error(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        super.fatalError(e);
    }

    public StandardDocument getDocument() {
        return this.document;
    }

    public Locator getDocumentLocator() {
        return this.documentLocator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.documentLocator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.document = new StandardDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        StandardElement parent = this.element;
        if (parent == null) {
            this.element = new StandardElement(this.document, parent, qName);
            this.document.setRootElement(this.element);
        } else {
            this.element = (StandardElement)parent.newElement(qName);
        }
        int i = 0;
        while (i < attributes.getLength()) {
            this.element.setAttributeTemplate(attributes.getLocalName(i), attributes.getValue(i));
            ++i;
        }
        this.sb.setLength(0);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        super.warning(e);
    }
}

