/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.StandardElement;
import de.intarsys.tools.infoset.XMLWriter;
import de.intarsys.tools.stream.StreamTools;
import java.io.StringWriter;

public class StandardDocument
implements IDocument,
IStringEvaluatorAccess {
    private IStringEvaluator stringEvaluator;
    private IStringEvaluator templateEvaluator;
    private StandardElement rootElement;

    @Override
    public String asXML() {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(writer);
            xmlWriter.write(this);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            return "<error>";
        }
        finally {
            StreamTools.close(writer);
        }
    }

    protected Object evaluate(String value) {
        if (this.templateEvaluator == null || value == null) {
            return value;
        }
        if (value.indexOf(36) >= 0) {
            try {
                return this.templateEvaluator.evaluate(value, Args.create());
            }
            catch (Exception e) {
                return "<error expanding '" + value + "'";
            }
        }
        return value;
    }

    @Override
    public IElement getRootElement() {
        return this.rootElement;
    }

    @Override
    public IStringEvaluator getStringEvaluator() {
        return this.stringEvaluator;
    }

    @Override
    public void setRootElement(IElement element) {
        this.rootElement = (StandardElement)element;
        ((StandardElement)element).setDocument(this);
    }

    @Override
    public void setStringEvaluator(IStringEvaluator evaluator) {
        this.stringEvaluator = evaluator;
        this.templateEvaluator = this.stringEvaluator == null ? null : TaggedStringEvaluator.decorate(evaluator);
    }

    public String toString() {
        return this.asXML();
    }
}

