/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.OutputFormat;
import de.intarsys.tools.infoset.StandardAttribute;
import de.intarsys.tools.infoset.StandardDocument;
import de.intarsys.tools.infoset.XMLWriter;
import de.intarsys.tools.reader.DirectTagReader;
import de.intarsys.tools.stream.StreamTools;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StandardElement
implements IElement {
    private StandardElement parent;
    private StandardDocument document;
    private String text = "";
    private List<IElement> elements;
    private Map<String, String> attributes;
    private String name;

    public StandardElement(StandardDocument document, StandardElement parent, String name) {
        this.document = document;
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String asXML() {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter(writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(this);
            String string = writer.toString();
            return string;
        }
        catch (Exception e) {
            return "<error>";
        }
        finally {
            StreamTools.close(writer);
        }
    }

    @Override
    public IAttribute attribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        String template = this.attributes.get(name);
        if (template == null) {
            return null;
        }
        StandardAttribute attr = new StandardAttribute(this);
        attr.setName(name);
        attr.setTemplate(template);
        return attr;
    }

    @Override
    public Iterator<String> attributeNames() {
        if (this.attributes == null) {
            return Collections.emptyIterator();
        }
        return this.attributes.keySet().iterator();
    }

    @Override
    public String attributeTemplate(String name) {
        IAttribute attr = this.attribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getTemplate();
    }

    @Override
    public String attributeValue(String name, String defaultValue) {
        IAttribute attr = this.attribute(name);
        if (attr == null) {
            return defaultValue;
        }
        return attr.getValue();
    }

    protected String condense(String pValue) {
        if (pValue == null) {
            return null;
        }
        return DirectTagReader.escape(pValue);
    }

    @Override
    public IElement element(String name) {
        if (this.elements == null) {
            return null;
        }
        for (IElement element : this.elements) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    @Override
    public Iterator<IElement> elementIterator() {
        if (this.elements == null) {
            return Collections.emptyIterator();
        }
        return this.elements.iterator();
    }

    @Override
    public Iterator<IElement> elementIterator(final String name) {
        if (this.elements == null) {
            return Collections.emptyIterator();
        }
        return new FilterIterator<IElement>(this.elements.iterator()){

            @Override
            protected boolean accept(IElement object) {
                return object.getName().equals(name);
            }
        };
    }

    @Override
    public void elementRemove(IElement pElement) {
        if (this.elements == null) {
            return;
        }
        this.elements.remove(pElement);
    }

    @Override
    public void elementsClear() {
        if (this.elements == null) {
            return;
        }
        this.elements.clear();
    }

    @Override
    public String elementText(String name) {
        IElement element = this.element(name);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    protected Object evaluate(String value) {
        if (value == null) {
            return value;
        }
        if (value.indexOf(36) >= 0) {
            if (this.parent != null) {
                return this.parent.evaluate(value);
            }
            if (this.document != null) {
                return this.document.evaluate(value);
            }
        }
        return value;
    }

    public StandardDocument getDocument() {
        return this.document;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public StandardElement getParent() {
        return this.parent;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.attribute(name) != null;
    }

    @Override
    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.size() > 0;
    }

    @Override
    public boolean hasElements() {
        return this.elements != null && this.elements.size() > 0;
    }

    @Override
    public boolean hasElements(String name) {
        return this.element(name) != null;
    }

    @Override
    public IElement newElement(String name) {
        StandardElement result = new StandardElement(this.document, this, name);
        if (this.elements == null) {
            this.elements = new ArrayList<IElement>();
        }
        this.elements.add(result);
        return result;
    }

    @Override
    public void setAttributeTemplate(String name, String template) {
        if (template == null) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(name);
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(name, template);
        }
    }

    @Override
    public void setAttributeValue(String name, String value) {
        if (value == null) {
            if (this.attributes == null) {
                return;
            }
            this.attributes.remove(name);
        } else {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(name, this.condense(value));
        }
    }

    public void setDocument(StandardDocument document) {
        this.document = document;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setParent(StandardElement parent) {
        this.parent = parent;
    }

    @Override
    public void setText(String value) {
        this.text = value;
    }

    public String toString() {
        return this.asXML();
    }
}

