/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.infoset;

import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.OutputFormat;
import de.intarsys.tools.xml.XMLTools;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;

public class XMLWriter {
    protected static final OutputFormat DEFAULT_FORMAT = new OutputFormat();
    private Writer writer;
    private OutputFormat format;
    private int indentLevel = 0;
    private int maximumAllowedCharacter;

    public XMLWriter(OutputStream out) throws UnsupportedEncodingException {
        this.format = DEFAULT_FORMAT;
        this.writer = this.createWriter(out, this.format.getEncoding());
    }

    public XMLWriter(OutputStream out, OutputFormat format) throws UnsupportedEncodingException {
        this.format = format;
        this.writer = this.createWriter(out, format.getEncoding());
    }

    public XMLWriter(Writer writer) {
        this(writer, DEFAULT_FORMAT);
    }

    public XMLWriter(Writer writer, OutputFormat format) {
        this.writer = writer;
        this.format = format;
    }

    protected Writer createWriter(OutputStream outStream, String encoding) throws UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter(outStream, encoding));
    }

    protected int defaultMaximumAllowedCharacter() {
        String encoding = this.format.getEncoding();
        if (encoding != null && encoding.equals("US-ASCII")) {
            return 127;
        }
        return -1;
    }

    public int getMaximumAllowedCharacter() {
        if (this.maximumAllowedCharacter == 0) {
            this.maximumAllowedCharacter = this.defaultMaximumAllowedCharacter();
        }
        return this.maximumAllowedCharacter;
    }

    protected OutputFormat getOutputFormat() {
        return this.format;
    }

    protected boolean isExpandEmptyElements() {
        return this.format.isExpandEmptyElements();
    }

    protected void println() throws IOException {
        this.writer.write(this.format.getLineSeparator());
    }

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    public void setMaximumAllowedCharacter(int maximumAllowedCharacter) {
        this.maximumAllowedCharacter = maximumAllowedCharacter;
    }

    protected boolean shouldEncodeChar(char c) {
        int max = this.getMaximumAllowedCharacter();
        return max > 0 && c > max;
    }

    public void write(IAttribute attribute) throws IOException {
        this.writeAttribute(attribute.getName(), attribute.getTemplate());
    }

    public void write(IDocument doc) throws IOException {
        this.writeDeclaration();
        this.writeElement(doc.getRootElement());
        this.writeln();
        this.writer.flush();
    }

    public void write(IElement element) throws IOException {
        this.writeElement(element);
        this.writer.flush();
    }

    protected void writeAttribute(String name, String value) throws IOException {
        this.writer.write(" ");
        this.writer.write(name);
        this.writer.write("=");
        char quote = this.format.getAttributeQuoteCharacter();
        this.writer.write(quote);
        this.writeEscapeAttributeEntities(value);
        this.writer.write(quote);
    }

    protected void writeAttributes(IElement element) throws IOException {
        Iterator<String> it = element.attributeNames();
        while (it.hasNext()) {
            String name = it.next();
            this.writeAttribute(name, element.attributeTemplate(name));
        }
    }

    protected void writeDeclaration() throws IOException {
        String encoding = this.format.getEncoding();
        if (!this.format.isSuppressDeclaration()) {
            if (encoding.equals("UTF8")) {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"UTF-8\"");
                }
                this.writer.write("?>");
            } else {
                this.writer.write("<?xml version=\"1.0\"");
                if (!this.format.isOmitEncoding()) {
                    this.writer.write(" encoding=\"" + encoding + "\"");
                }
                this.writer.write("?>");
            }
            if (this.format.isNewLineAfterDeclaration()) {
                this.println();
            }
        }
    }

    protected void writeElement(IElement element) throws IOException {
        String qualifiedName = element.getName();
        this.writeln();
        this.writeIndent();
        this.writer.write("<");
        this.writer.write(qualifiedName);
        this.writeAttributes(element);
        boolean empty = true;
        if (element.getText() == null && !element.hasElements()) {
            if (!this.format.isExpandEmptyElements()) {
                this.writer.write("/>");
            } else {
                this.writer.write("></");
                this.writer.write(qualifiedName);
                this.writer.write(">");
            }
        } else {
            this.writer.write(">");
            ++this.indentLevel;
            this.writeElementContent(element);
            --this.indentLevel;
            this.writeln();
            this.writeIndent();
            this.writer.write("</");
            this.writer.write(qualifiedName);
            this.writer.write(">");
        }
    }

    protected void writeElementContent(IElement element) throws IOException {
        String value = element.getText();
        boolean trim = this.format.isTrimText();
        if (value != null) {
            if (trim) {
                this.writeString(value.trim());
            } else {
                this.writeString(value);
            }
        }
        Iterator<IElement> it = element.elementIterator();
        while (it.hasNext()) {
            IElement node = it.next();
            this.write(node);
        }
    }

    protected void writeEscapeAttributeEntities(String txt) throws IOException {
        if (txt != null) {
            String escapedText = XMLTools.encodeSpecialChars(txt);
            this.writer.write(escapedText);
        }
    }

    protected void writeIndent() throws IOException {
        String indent = this.format.getIndent();
        if (indent != null && indent.length() > 0) {
            int i = 0;
            while (i < this.indentLevel) {
                this.writer.write(indent);
                ++i;
            }
        }
    }

    protected void writeln() throws IOException {
        if (this.format.isNewlines()) {
            this.writer.write(this.format.getLineSeparator());
        }
    }

    protected void writeString(String text) throws IOException {
        if (text != null && text.length() > 0) {
            if (this.format.isEscapeText()) {
                text = XMLTools.encodeSpecialChars(text);
            }
            if (this.format.isTrimText()) {
                this.writer.write(text.trim());
            } else {
                this.writer.write(text);
            }
        }
    }
}

