/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.installresource;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.system.SystemTools;
import de.intarsys.tools.url.URLTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public abstract class Install {
    private static String platformId;
    private static String platformFallbackId;
    private static String platformDefaultId;
    private boolean platformDependent = false;
    protected final String name;
    protected final String path;
    protected File[] files;
    protected ClassLoader classLoader;

    protected static void copy(URL url, File file) throws IOException, FileNotFoundException {
        InputStream is = url.openStream();
        FileOutputStream os = null;
        try {
            try {
                os = new FileOutputStream(file);
                StreamTools.copyStream(is, os);
            }
            catch (IOException e) {
                throw new IOException("resource '" + url.getFile() + "' load error", e);
            }
        }
        finally {
            StreamTools.close(is);
            StreamTools.close(os);
        }
    }

    protected static String createPlatformFallbackId() {
        String[] split = SystemTools.getOSName().split("\\s");
        return (String.valueOf(split[0]) + "-" + SystemTools.getOSArch()).toLowerCase();
    }

    protected static String createPlatformId() {
        return (String.valueOf(SystemTools.getOSName()) + "-" + SystemTools.getOSArch()).toLowerCase();
    }

    protected static void deleteOnExit(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                File child = children[i];
                Install.deleteOnExit(child);
                ++i;
            }
        }
        file.deleteOnExit();
    }

    public static String getPlatformDefaultId() {
        if (platformDefaultId == null) {
            return "default";
        }
        return platformDefaultId;
    }

    public static String getPlatformFallbackId() {
        if (platformFallbackId == null) {
            return Install.createPlatformFallbackId();
        }
        return platformFallbackId;
    }

    public static String getPlatformId() {
        if (platformId == null) {
            return Install.createPlatformId();
        }
        return platformId;
    }

    public static void setPlatformDefaultId(String value) {
        platformDefaultId = value;
    }

    public static void setPlatformFallbackId(String value) {
        platformFallbackId = value;
    }

    public static void setPlatformId(String value) {
        platformId = value;
    }

    public Install(String path, String name, boolean platformDependent) {
        String tempPath = URLTools.withoutLeadingSeparator(path);
        this.path = tempPath = URLTools.withoutTrailingSeparator(tempPath);
        this.name = name;
        this.platformDependent = platformDependent;
    }

    public boolean delete() {
        if (this.files == null) {
            return true;
        }
        boolean deleted = true;
        int i = 0;
        while (i < this.files.length) {
            File file = this.files[i];
            deleted = deleted && FileTools.deleteRecursivly(file);
            ++i;
        }
        return deleted;
    }

    protected Iterator<URL> find(String name) {
        Iterator<URL> urls = null;
        try {
            if (this.isPlatformDependent()) {
                urls = this.open(this.getResourceNameFull(name));
                if (!urls.hasNext() && !(urls = this.open(this.getResourceNameFallback(name))).hasNext()) {
                    urls = this.open(this.getResourceNameDefault(name));
                }
            } else {
                urls = this.open(this.getResourceNamePlain(name));
            }
        }
        catch (Exception e) {
            urls = Collections.emptyIterator();
        }
        return urls;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            ClassLoader result = Thread.currentThread().getContextClassLoader();
            if (result == null) {
                result = this.getClass().getClassLoader();
            }
            return result;
        }
        return this.classLoader;
    }

    public File getFile() {
        if (this.files == null || this.files.length == 0) {
            return null;
        }
        return this.files[0];
    }

    public File[] getFiles() {
        return this.files;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    protected String getResourceNameDefault(String name) {
        return String.valueOf(Install.getPlatformDefaultId()) + "/" + name;
    }

    protected String getResourceNameFallback(String name) {
        return String.valueOf(Install.getPlatformFallbackId()) + "/" + name;
    }

    protected String getResourceNameFull(String name) {
        return String.valueOf(Install.getPlatformId()) + "/" + name;
    }

    protected String getResourceNamePlain(String name) {
        return name;
    }

    public boolean isPlatformDependent() {
        return this.platformDependent;
    }

    public File load() throws IOException {
        Iterator<URL> urls = this.find(this.getName());
        if (urls.hasNext()) {
            URL url = urls.next();
            File file = this.loadURL(url);
            Install.deleteOnExit(file);
            this.files = new File[]{file};
            return file;
        }
        return null;
    }

    public File[] loadAll() throws IOException {
        ArrayList<File> tempFiles = new ArrayList<File>();
        Iterator<URL> urls = this.find(this.getName());
        while (urls.hasNext()) {
            URL url = urls.next();
            File file = this.loadURL(url);
            Install.deleteOnExit(file);
            tempFiles.add(file);
        }
        this.files = tempFiles.toArray(new File[tempFiles.size()]);
        return this.files;
    }

    protected abstract File loadURL(URL var1) throws IOException;

    protected Iterator<URL> open(String name) throws IOException {
        String resourceName = this.prefix(name);
        Enumeration<URL> urls = this.getClassLoader().getResources(resourceName);
        if (urls.hasMoreElements()) {
            HashSet<URL> urlSet = new HashSet<URL>();
            urlSet.addAll(Collections.list(urls));
            return urlSet.iterator();
        }
        return Collections.emptyIterator();
    }

    protected String prefix(String name) {
        StringBuilder sb = new StringBuilder();
        if (this.getPath() != null) {
            sb.append(this.getPath());
            if (sb.length() > 0) {
                sb.append("/");
            }
        }
        sb.append(name);
        return sb.toString();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

