/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.installresource;

import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.installresource.Install;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class InstallZip
extends Install {
    public InstallZip(String path, String name, boolean platformDependent) {
        super(path, name, platformDependent);
    }

    protected void loadEntry(File parent, ZipFile zipFile, ZipEntry entry) throws IOException, FileNotFoundException {
        InputStream is = null;
        FileOutputStream os = null;
        String entryName = entry.getName();
        File entryFile = new File(parent, entryName);
        if (entry.isDirectory()) {
            entryFile.mkdirs();
        } else {
            File entryDir = entryFile.getParentFile();
            if (entryDir != null && !entryDir.exists()) {
                entryDir.mkdirs();
            }
            is = zipFile.getInputStream(entry);
            os = new FileOutputStream(entryFile);
            StreamTools.copyStream(is, os);
        }
    }

    @Override
    protected File loadURL(URL url) throws IOException {
        File file = TempTools.createTempFile("file", this.getName());
        InstallZip.copy(url, file);
        InstallZip.deleteOnExit(file);
        File dir = TempTools.createTempDir("dir", this.getName());
        this.loadZip(file, dir);
        return dir;
    }

    protected void loadZip(File zip, File parent) throws ZipException, IOException {
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                this.loadEntry(parent, zipFile, entry);
            }
        }
    }
}

