/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ipc;

import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.ipc.IIPCScope;
import de.intarsys.tools.ipc.IPCHandle;
import de.intarsys.tools.ipc.IPCObject;
import de.intarsys.tools.ipc.IPCScope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IPCMarshaller {
    protected IIPCScope getScope() {
        return IPCScope.get();
    }

    public Object marshall(Object value) throws IOException {
        if (value instanceof IArgs) {
            return this.marshallArgs((IArgs)value);
        }
        if (value instanceof Map) {
            return this.marshallMap((Map)value);
        }
        if (value instanceof Object[]) {
            return this.marshallArray((Object[])value);
        }
        if (value instanceof Collection) {
            return this.marshallCollection((Collection)value);
        }
        if (value instanceof Iterator) {
            return this.marshallIterator((Iterator)value);
        }
        try {
            value = ConverterRegistry.get().convert(value, IPCObject.class);
        }
        catch (ConversionException e) {
            throw new IOException(e);
        }
        return value;
    }

    protected Object marshallArgs(IArgs args) throws IOException {
        Args tempCopy = Args.create();
        boolean touched = false;
        int i = 0;
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            String name = binding.getName();
            Object value = binding.getValue();
            Object newValue = this.marshall(value);
            tempCopy.add(newValue).setName(name);
            if (newValue != value) {
                touched = true;
            }
            ++i;
        }
        return touched ? tempCopy : args;
    }

    protected Object marshallArray(Object[] array) throws IOException {
        Object[] tempCopy = new Object[array.length];
        boolean touched = false;
        int i = 0;
        while (i < array.length) {
            Object newValue;
            Object value = array[i];
            tempCopy[i] = newValue = this.marshall(value);
            if (newValue != value) {
                touched = true;
            }
            ++i;
        }
        return touched ? tempCopy : array;
    }

    protected Object marshallCollection(Collection collection) throws IOException {
        ArrayList<Object> tempCopy = new ArrayList<Object>(collection.size());
        boolean touched = false;
        for (Object value : collection) {
            Object newValue = this.marshall(value);
            tempCopy.add(newValue);
            if (newValue == value) continue;
            touched = true;
        }
        return touched ? tempCopy : collection;
    }

    protected Object marshallIterator(Iterator iterator) {
        final IIPCScope deferredScope = this.getScope();
        return new ConversionIterator(iterator){

            protected Object createTargetObject(Object sourceObject) {
                IIPCScope currentScope = IPCScope.lookup();
                try {
                    IPCScope.set(deferredScope);
                    Object object = IPCMarshaller.this.marshall(sourceObject);
                    return object;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    IPCScope.set(currentScope);
                }
            }
        };
    }

    protected Object marshallMap(Map map) throws IOException {
        HashMap tempCopy = new HashMap(map.size());
        boolean touched = false;
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object newValue = this.marshall(value);
            tempCopy.put(key, newValue);
            if (newValue != value) {
                touched = true;
            }
            ++i;
        }
        return touched ? tempCopy : map;
    }

    public Object unmarshall(Object value) throws IOException {
        if (value instanceof IArgs) {
            return this.unmarshallArgs((IArgs)value);
        }
        if (value instanceof Map) {
            return this.unmarshallMap((Map)value);
        }
        if (value instanceof Object[]) {
            return this.unmarshallArray((Object[])value);
        }
        if (value instanceof Collection) {
            return this.unmarshallCollection((Collection)value);
        }
        if (value instanceof Iterator) {
            return this.unmarshallIterator((Iterator)value);
        }
        if (value instanceof String) {
            return this.unmarshallString((String)value);
        }
        return value;
    }

    protected Object unmarshallArgs(IArgs args) throws IOException {
        int i = 0;
        Iterator<IArgs.IBinding> it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = it.next();
            Object value = binding.getValue();
            Object newValue = this.unmarshall(value);
            binding.setValue(newValue);
            ++i;
        }
        return args;
    }

    protected Object unmarshallArray(Object[] array) throws IOException {
        Object[] tempCopy = new Object[array.length];
        boolean touched = false;
        int i = 0;
        while (i < array.length) {
            Object newValue;
            Object value = array[i];
            tempCopy[i] = newValue = this.unmarshall(value);
            if (newValue != value) {
                touched = true;
            }
            ++i;
        }
        return touched ? tempCopy : array;
    }

    protected Object unmarshallCollection(Collection collection) throws IOException {
        ArrayList<Object> tempCopy = new ArrayList<Object>(collection.size());
        boolean touched = false;
        for (Object value : collection) {
            Object newValue = this.unmarshall(value);
            tempCopy.add(newValue);
            if (newValue == value) continue;
            touched = true;
        }
        return touched ? tempCopy : collection;
    }

    protected Object unmarshallIterator(Iterator iterator) {
        return new ConversionIterator(iterator){

            protected Object createTargetObject(Object sourceObject) {
                try {
                    return IPCMarshaller.this.unmarshall(sourceObject);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    protected Object unmarshallMap(Map map) throws IOException {
        HashMap tempCopy = new HashMap(map.size());
        boolean touched = false;
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object newValue = this.unmarshall(value);
            tempCopy.put(key, newValue);
            if (newValue != value) {
                touched = true;
            }
            ++i;
        }
        return touched ? tempCopy : map;
    }

    protected Object unmarshallString(String value) throws IOException {
        String tempString = value;
        if (tempString.startsWith("ipc://")) {
            try {
                IPCHandle handle = this.getScope().importHandle(tempString);
                if (handle.isResolved()) {
                    return handle.getObject();
                }
                return handle;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return value;
    }
}

