/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.json;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.json.JsonArray;
import de.intarsys.tools.json.JsonObject;
import de.intarsys.tools.json.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class Json {
    public static JsonArray createArray() {
        JsonArray result = new JsonArray();
        return result;
    }

    public static JsonArray createArray(Collection collection) {
        JsonArray result = new JsonArray();
        if (collection != null) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                result.basicAdd(Json.wrap(iter.next()));
            }
        }
        return result;
    }

    public static JsonObject createObject() {
        JsonObject result = new JsonObject();
        return result;
    }

    public static JsonObject createObject(Map<String, Object> map) {
        JsonObject result = new JsonObject();
        if (map != null) {
            for (Map.Entry<String, Object> e : map.entrySet()) {
                Object value = e.getValue();
                if (value == null) continue;
                result.basicPut(e.getKey(), Json.wrap(value));
            }
        }
        return result;
    }

    public static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        String string = Double.toString(d);
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String numberToString(Number number) {
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static String quote(String string) {
        StringWriter w = new StringWriter();
        try {
            JsonWriter.quote(string, w);
            return w.toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    public static boolean toBoolean(Object object) throws ConversionException {
        if (object != null) {
            if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
                return false;
            }
            if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
                return true;
            }
        }
        throw new ConversionException("not a boolean.");
    }

    public static double toDouble(Object object) throws ConversionException {
        try {
            if (object != null) {
                if (object instanceof Number) {
                    return ((Number)object).doubleValue();
                }
                if (object instanceof String) {
                    return Double.parseDouble((String)object);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ConversionException("not a double");
    }

    public static int toInt(Object object) throws ConversionException {
        try {
            if (object != null) {
                if (object instanceof Number) {
                    return ((Number)object).intValue();
                }
                if (object instanceof String) {
                    return Integer.parseInt((String)object);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ConversionException("not an int");
    }

    public static long toLong(Object object) throws ConversionException {
        try {
            if (object != null) {
                if (object instanceof Number) {
                    return ((Number)object).longValue();
                }
                if (object instanceof String) {
                    return Long.parseLong((String)object);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ConversionException("not an int");
    }

    public static String toString(Object object) throws ConversionException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static String valueToString(Object value) throws IOException {
        if (value == null) {
            return "null";
        }
        if (value instanceof Number) {
            return Json.numberToString((Number)value);
        }
        if (value instanceof Boolean || value instanceof JsonObject || value instanceof JsonArray) {
            return value.toString();
        }
        return Json.quote(value.toString());
    }

    public static Object wrap(Object object) {
        block6: {
            try {
                if (object != null) break block6;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (object instanceof JsonObject || object instanceof JsonArray || object instanceof Number || object instanceof Boolean || object instanceof String) {
            return object;
        }
        if (object instanceof Collection) {
            return Json.createArray((Collection)object);
        }
        if (object instanceof Map) {
            return Json.createObject((Map)object);
        }
        return object.toString();
    }
}

