/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.json;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.json.Json;
import de.intarsys.tools.json.JsonObject;
import de.intarsys.tools.json.JsonWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JsonArray {
    private final List<Object> list = new ArrayList<Object>();

    protected JsonArray() {
    }

    public JsonArray add(boolean value) {
        return this.basicAdd(value);
    }

    public JsonArray add(double value) {
        return this.basicAdd(value);
    }

    public JsonArray add(int value) {
        return this.basicAdd(value);
    }

    public JsonArray add(JsonArray value) {
        return this.basicAdd(value);
    }

    public JsonArray add(JsonObject value) {
        return this.basicAdd(value);
    }

    public JsonArray add(long value) {
        return this.basicAdd(value);
    }

    public JsonArray add(String value) {
        return this.basicAdd(value);
    }

    protected JsonArray basicAdd(Object value) {
        this.list.add(value);
        return this;
    }

    public void clear() {
        this.list.clear();
    }

    public Object get(int index) {
        return index < 0 || index >= this.size() ? null : this.list.get(index);
    }

    public boolean getBoolean(int index) throws ConversionException {
        Object object = this.get(index);
        return Json.toBoolean(object);
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDouble(int index) throws ConversionException {
        Object object = this.get(index);
        return Json.toDouble(object);
    }

    public double getDouble(int index, double defaultValue) {
        try {
            return this.getDouble(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getInt(int index) throws ConversionException {
        Object object = this.get(index);
        return Json.toInt(object);
    }

    public int getInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JsonArray getJSONArray(int index) throws ConversionException {
        Object object = this.get(index);
        if (object instanceof JsonArray) {
            return (JsonArray)object;
        }
        throw new ConversionException("not a JSONArray.");
    }

    public JsonArray getJSONArray(int index, JsonArray defaultValue) {
        Object o = this.get(index);
        return o instanceof JsonArray ? (JsonArray)o : defaultValue;
    }

    public JsonObject getJSONObject(int index) throws ConversionException {
        Object object = this.get(index);
        if (object instanceof JsonObject) {
            return (JsonObject)object;
        }
        throw new ConversionException("not a JSONObject.");
    }

    public JsonObject getJSONObject(int index, JsonObject defaultValue) {
        Object o = this.get(index);
        return o instanceof JsonObject ? (JsonObject)o : defaultValue;
    }

    public long getLong(int index) throws ConversionException {
        Object object = this.get(index);
        return Json.toLong(object);
    }

    public long getLong(int index, long defaultValue) {
        try {
            return this.getLong(index);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getString(int index) throws ConversionException {
        Object object = this.get(index);
        return Json.toString(object);
    }

    public String getString(int index, String defaultValue) {
        try {
            return this.getString(index);
        }
        catch (ConversionException e) {
            return defaultValue;
        }
    }

    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    public JsonArray remove(int index) {
        this.list.remove(index);
        return this;
    }

    public int size() {
        return this.list.size();
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indentFactor) {
        StringWriter w = new StringWriter();
        try {
            new JsonWriter(w).write(this, indentFactor, 0);
            return w.toString();
        }
        catch (Exception e) {
            return "[ ]";
        }
    }
}

