/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.json;

import de.intarsys.tools.json.JsonArray;
import de.intarsys.tools.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public class JsonReader {
    private long column;
    private long index;
    private long line;
    private int buffer;
    private final Reader reader;

    public JsonReader(InputStream inputStream) throws IOException {
        this(new InputStreamReader(inputStream, "UTF-8"));
    }

    protected Reader getReader() {
        return this.reader;
    }

    public JsonReader(Reader pReader) {
        this.reader = pReader.markSupported() ? pReader : new BufferedReader(pReader);
        this.buffer = 0;
        this.index = 0L;
        this.column = 0L;
        this.line = 1L;
    }

    public JsonReader(String s) {
        this(new StringReader(s));
    }

    protected void unread(int c) throws IOException {
        this.buffer = c;
    }

    protected int read(boolean endExpected) throws IOException {
        if (this.buffer != 0) {
            int c = this.buffer;
            this.buffer = 0;
            return c;
        }
        int c = this.reader.read();
        if (c == -1) {
            if (!endExpected) {
                throw this.error("unexpected end of input");
            }
            return c;
        }
        ++this.index;
        if (c == 10) {
            ++this.line;
            this.column = 0L;
        } else {
            ++this.column;
        }
        return c;
    }

    protected char[] read(int n) throws IOException {
        char[] chars = new char[n];
        int pos = 0;
        while (pos < n) {
            char c = (char)this.read(false);
            chars[pos++] = c;
        }
        return chars;
    }

    protected int readNonWS(boolean endExpected) throws IOException {
        int c;
        while ((c = this.read(endExpected)) != -1 && c <= 32) {
        }
        return c;
    }

    public JsonArray readJsonArray() throws IOException {
        int c = this.readNonWS(true);
        if (c == -1) {
            return null;
        }
        if (c != 91) {
            throw this.error("'[' expected");
        }
        JsonArray result = new JsonArray();
        c = this.readNonWS(false);
        if (c == 93) {
            return result;
        }
        while (true) {
            this.unread(c);
            result.basicAdd(this.readValue());
            c = this.readNonWS(false);
            if (c != 44) break;
            c = this.readNonWS(false);
        }
        if (c == 93) {
            return result;
        }
        throw this.error("',' or ']' expected");
    }

    public JsonObject readJsonObject() throws IOException {
        int c = this.readNonWS(true);
        if (c == 1) {
            return null;
        }
        if (c != 123) {
            throw this.error("'{' expected");
        }
        JsonObject result = new JsonObject();
        c = this.readNonWS(false);
        if (c == 125) {
            return result;
        }
        while (true) {
            this.unread(c);
            Object value = this.readValue();
            String key = value == null ? null : value.toString();
            c = this.readNonWS(false);
            if (c != 58) {
                throw this.error("':' expected");
            }
            value = this.readValue();
            result.basicPut(key, value);
            c = this.readNonWS(false);
            if (c == 125) {
                return result;
            }
            if (c != 44) break;
            c = this.readNonWS(false);
        }
        throw this.error("',' or '}' expected");
    }

    public String readString(int quote) throws IOException {
        int c = this.readNonWS(true);
        if (c == 1) {
            return null;
        }
        if (c != quote) {
            throw this.error("'" + (char)quote + "' expected");
        }
        StringBuffer sb = new StringBuffer();
        block13: while (true) {
            c = this.read(false);
            switch (c) {
                case 10: 
                case 13: {
                    throw this.error("string not terminated");
                }
                case 92: {
                    c = this.read(false);
                    switch (c) {
                        case 98: {
                            sb.append('\b');
                            continue block13;
                        }
                        case 116: {
                            sb.append('\t');
                            continue block13;
                        }
                        case 110: {
                            sb.append('\n');
                            continue block13;
                        }
                        case 102: {
                            sb.append('\f');
                            continue block13;
                        }
                        case 114: {
                            sb.append('\r');
                            continue block13;
                        }
                        case 117: {
                            sb.append((char)Integer.parseInt(new String(this.read(4)), 16));
                            continue block13;
                        }
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            sb.append((char)c);
                            continue block13;
                        }
                    }
                    throw this.error("illegal escape code '\\" + (char)c + "'");
                }
            }
            if (c == quote) {
                return sb.toString();
            }
            sb.append((char)c);
        }
    }

    public Object readValue() throws IOException {
        int c = this.readNonWS(true);
        switch (c) {
            case -1: {
                return null;
            }
            case 34: 
            case 39: {
                this.unread(c);
                return this.readString(c);
            }
            case 123: {
                this.unread(c);
                return this.readJsonObject();
            }
            case 91: {
                this.unread(c);
                return this.readJsonArray();
            }
        }
        this.unread(c);
        return this.readUnquoted();
    }

    public Object readUnquoted() throws IOException {
        int c = this.readNonWS(true);
        if (c == -1) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        while (c > 32 && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append((char)c);
            c = this.read(true);
        }
        String token = sb.toString().trim();
        if (token.length() == 0) {
            throw this.error("unexpected char '" + (char)c + "'");
        }
        if (c != -1) {
            this.unread(c);
        }
        return JsonReader.tokenToValue(token);
    }

    protected IOException error(String message) {
        return new IOException(String.valueOf(message) + this.getPosition());
    }

    protected String getPosition() {
        return " at " + this.index + " [" + this.line + ", " + this.column + " ]";
    }

    public static Object tokenToValue(String string) {
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.equalsIgnoreCase("null")) {
            return null;
        }
        char b = string.charAt(0);
        if (b >= '0' && b <= '9' || b == '-' || b == '.') {
            try {
                if (string.indexOf(46) > -1 || string.indexOf(101) > -1 || string.indexOf(69) > -1) {
                    Double d = Double.valueOf(string);
                    if (!d.isInfinite() && !d.isNaN()) {
                        return d;
                    }
                } else {
                    Long myLong = new Long(string);
                    if (string.equals(myLong.toString())) {
                        if (myLong == (long)myLong.intValue()) {
                            return new Integer(myLong.intValue());
                        }
                        return myLong;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }
}

