/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.json;

import de.intarsys.tools.json.Json;
import de.intarsys.tools.json.JsonArray;
import de.intarsys.tools.json.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class JsonWriter {
    private final Writer writer;

    public static void quote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    w.write(92);
                    w.write(c);
                    break;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    break;
                }
                case '\b': {
                    w.write("\\b");
                    break;
                }
                case '\t': {
                    w.write("\\t");
                    break;
                }
                case '\n': {
                    w.write("\\n");
                    break;
                }
                case '\f': {
                    w.write("\\f");
                    break;
                }
                case '\r': {
                    w.write("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                        break;
                    }
                    w.write(c);
                }
            }
            ++i;
        }
        w.write(34);
    }

    public JsonWriter(Writer w) {
        this.writer = w;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected void indent(Writer writer, int indent) throws IOException {
        int i = 0;
        while (i < indent) {
            writer.write(32);
            ++i;
        }
    }

    public void write(Object value, int indentFactor, int indent) throws IOException {
        if (value == null) {
            this.getWriter().write("null");
        } else if (value instanceof JsonObject) {
            this.writeObject((JsonObject)value, indentFactor, indent);
        } else if (value instanceof JsonArray) {
            this.writeArray((JsonArray)value, indentFactor, indent);
        } else if (value instanceof Number) {
            this.getWriter().write(Json.numberToString((Number)value));
        } else if (value instanceof Boolean) {
            this.getWriter().write(value.toString());
        } else {
            JsonWriter.quote(value.toString(), this.writer);
        }
    }

    protected void writeArray(JsonArray value, int indentFactor, int indent) throws IOException {
        boolean commanate = false;
        int length = value.size();
        this.writer.write(91);
        if (length == 1) {
            this.write(value.get(0), indentFactor, indent);
        } else if (length != 0) {
            int newindent = indent + indentFactor;
            Iterator<Object> it = value.iterator();
            while (it.hasNext()) {
                Object child = it.next();
                if (commanate) {
                    this.writer.write(44);
                }
                if (indentFactor > 0) {
                    this.writer.write(10);
                }
                this.indent(this.writer, newindent);
                this.write(child, indentFactor, newindent);
                commanate = true;
            }
            if (indentFactor > 0) {
                this.writer.write(10);
            }
            this.indent(this.writer, indent);
        }
        this.writer.write(93);
    }

    protected void writeObject(JsonObject value, int indentFactor, int indent) throws IOException {
        boolean commanate = false;
        int length = value.size();
        Iterator<String> itNames = value.names().iterator();
        this.writer.write(123);
        if (length == 1) {
            String key = itNames.next();
            this.writer.write(Json.quote(key.toString()));
            this.writer.write(58);
            if (indentFactor > 0) {
                this.writer.write(32);
            }
            this.write(value.get(key), indentFactor, indent);
        } else if (length != 0) {
            int newindent = indent + indentFactor;
            while (itNames.hasNext()) {
                String key = itNames.next();
                if (commanate) {
                    this.writer.write(44);
                }
                if (indentFactor > 0) {
                    this.writer.write(10);
                }
                this.indent(this.writer, newindent);
                this.writer.write(Json.quote(key.toString()));
                this.writer.write(58);
                if (indentFactor > 0) {
                    this.writer.write(32);
                }
                this.write(value.get(key), indentFactor, newindent);
                commanate = true;
            }
            if (indentFactor > 0) {
                this.writer.write(10);
            }
            this.indent(this.writer, indent);
        }
        this.writer.write(125);
    }
}

