/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.charset.ICharsetAccess;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;

public class ByteArrayLocator
extends CommonLocator
implements Serializable,
ICharsetAccess {
    protected byte[] content;
    protected int length;
    private String fullName;
    private String localName;
    private String type;
    private String charset;

    public ByteArrayLocator(byte[] data, String pFullName) {
        if (data == null) {
            data = new byte[]{};
        }
        this.content = data;
        this.length = data.length;
        this.setFullName(pFullName);
    }

    public ByteArrayLocator(byte[] data, String pName, String pType) {
        if (data == null) {
            data = new byte[]{};
        }
        this.content = data;
        this.length = data.length;
        if (StringTools.isEmpty(pType)) {
            this.setFullName(pName);
        } else {
            this.setFullName(String.valueOf(pName) + "." + pType);
        }
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return this.content != null;
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.content, 0, result, 0, this.length);
        return result;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public ILocator getChild(String name) {
        return null;
    }

    public byte[] getContent() {
        return this.content;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content, 0, this.length);
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public OutputStream getOutputStream() {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                ByteArrayLocator.this.content = this.buf;
                ByteArrayLocator.this.length = this.count;
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                ByteArrayLocator.this.content = this.buf;
                ByteArrayLocator.this.length = this.count;
            }
        };
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public IRandomAccess getRandomAccess() {
        return new RandomAccessByteArray(this.content, this.length){

            @Override
            public void flush() throws IOException {
                super.flush();
                ByteArrayLocator.this.content = this.data;
                ByteArrayLocator.this.length = this.length;
            }
        };
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.getCharset() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getCharset());
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        return new InputStreamReader(this.getInputStream(), encoding);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypedName() {
        return this.type == null ? this.localName : String.valueOf(this.localName) + "." + this.type;
    }

    @Override
    public Writer getWriter() throws IOException {
        if (this.getCharset() == null) {
            return new OutputStreamWriter(this.getOutputStream());
        }
        return new OutputStreamWriter(this.getOutputStream(), this.getCharset());
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        return new OutputStreamWriter(this.getOutputStream(), encoding);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) {
        return new ILocator[0];
    }

    @Override
    public void rename(String newName) throws IOException {
        this.setFullName(newName);
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected void setFullName(String newName) {
        this.fullName = newName;
        this.localName = FileTools.getBaseName(newName);
        this.type = FileTools.getExtension(newName, null, this.getType());
    }

    @Override
    public void synch() {
    }

    @Override
    public URL toURL() {
        return null;
    }
}

